/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.motif;

import ca.mcgill.mcb.pcingola.util.Gpr;

public class Pwm {
    public static final int SCALE = 100;
    static final double LOG2 = Math.log(2.0);
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    int[][] countMatrix;
    int[] count;
    double[][] logOdds;
    int length;
    int totalCount;

    public Pwm(int length) {
        this.length = length;
        this.countMatrix = new int[BASES.length][length];
        this.count = new int[BASES.length];
        this.logOdds = null;
    }

    public Pwm(String file) {
        String data2 = Gpr.readFile(file);
        String[] lines2 = data2.split("\n");
        this.length = lines2.length;
        this.countMatrix = new int[BASES.length][this.length];
        this.count = new int[BASES.length];
        this.logOdds = new double[BASES.length][this.length];
        int lineNum = 0;
        while (lineNum < lines2.length) {
            String[] val = lines2[lineNum].trim().split("\\s+");
            int baseNum = 0;
            while (baseNum < BASES.length) {
                this.logOdds[baseNum][lineNum] = Gpr.parseDoubleSafe(val[baseNum]);
                ++baseNum;
            }
            ++lineNum;
        }
    }

    int base2int(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 3;
            }
        }
        return -1;
    }

    public void calcLogOddsWeight() {
        this.logOdds = new double[BASES.length][this.length];
        double[] b = new double[BASES.length];
        int total = 0;
        int baseNum = 0;
        while (baseNum < BASES.length) {
            total += this.count[baseNum] + 1;
            ++baseNum;
        }
        baseNum = 0;
        while (baseNum < BASES.length) {
            b[baseNum] = (double)(this.count[baseNum] + 1) / (double)total;
            ++baseNum;
        }
        int i = 0;
        while (i < this.countMatrix.length) {
            int baseNum2 = 0;
            while (baseNum2 < BASES.length) {
                double p = (double)(this.countMatrix[baseNum2][i] + 1) / (double)total;
                this.logOdds[baseNum2][i] = Math.log(p / b[baseNum2]) / LOG2;
                ++baseNum2;
            }
            ++i;
        }
    }

    public int getCount(char base, int position) {
        return this.countMatrix[this.base2int(base)][position];
    }

    public double getLogOdds(char base, int position) {
        return this.logOdds[this.base2int(base)][position];
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int length() {
        return this.length;
    }

    public double score(String dna) {
        if (this.logOdds == null) {
            this.calcLogOddsWeight();
        }
        char[] bases = dna.toCharArray();
        int score = 0;
        int i = 0;
        while (i < bases.length) {
            score = (int)((double)score + this.getLogOdds(bases[i], i));
            ++i;
        }
        return (double)score / (double)(this.length * 100);
    }

    public void set(String dna) {
        char[] bases = dna.toCharArray();
        int i = 0;
        while (i < bases.length) {
            int j = 0;
            while (j < BASES.length) {
                this.countMatrix[j][i] = 1;
                ++j;
            }
            this.countMatrix[this.base2int((char)bases[i])][i] = 100;
            ++i;
        }
    }

    int size() {
        return this.countMatrix[0].length;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Counts:\n");
        int b = 0;
        while (b < BASES.length) {
            sb.append(String.valueOf(BASES[b]) + "\t");
            i = 0;
            while (i < this.countMatrix[b].length) {
                sb.append(String.format("%10d  ", this.countMatrix[b][i]));
                ++i;
            }
            sb.append("\n");
            ++b;
        }
        sb.append("Max:\t");
        int i2 = 0;
        while (i2 < this.countMatrix[0].length) {
            int max2 = 0;
            int maxb = 0;
            int b2 = 0;
            while (b2 < BASES.length) {
                if (max2 < this.countMatrix[b2][i2]) {
                    max2 = this.countMatrix[b2][i2];
                    maxb = b2;
                }
                ++b2;
            }
            sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
            ++i2;
        }
        sb.append("\n");
        sb.append("\nWeights:\n");
        b = 0;
        while (b < BASES.length) {
            sb.append(String.valueOf(BASES[b]) + "\t");
            i = 0;
            while (i < this.logOdds[b].length) {
                sb.append(String.format("%10.2f  ", this.logOdds[b][i]));
                ++i;
            }
            sb.append("\n");
            ++b;
        }
        sb.append("Max:\t");
        i2 = 0;
        while (i2 < this.countMatrix[0].length) {
            int maxb = 0;
            double max3 = Double.NEGATIVE_INFINITY;
            int b3 = 0;
            while (b3 < BASES.length) {
                if (max3 < this.logOdds[b3][i2]) {
                    max3 = this.logOdds[b3][i2];
                    maxb = b3;
                }
                ++b3;
            }
            sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
            ++i2;
        }
        sb.append("\n");
        return sb.toString();
    }

    public void updateCounts(String dna) {
        this.updateCounts(dna, 1);
    }

    public void updateCounts(String dna, int inc) {
        this.totalCount += inc;
        char[] bases = dna.toCharArray();
        int i = 0;
        while (i < bases.length) {
            int code = this.base2int(bases[i]);
            if (code >= 0) {
                int[] nArray = this.countMatrix[code];
                int n = i;
                nArray[n] = nArray[n] + inc;
                int n2 = code;
                this.count[n2] = this.count[n2] + inc;
            }
            ++i;
        }
    }
}

