/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;

public class CodonChangeSnp
extends CodonChange {
    public CodonChangeSnp(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        super(seqChange, transcript, changeEffect);
        this.returnNow = true;
    }

    @Override
    boolean codonChangeSingle(ChangeEffect changeEffect, Exon exon) {
        this.codonsOld = this.codonsOld();
        this.codonsNew = this.codonsNew();
        changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_CHANGE, "");
        changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
        return true;
    }

    @Override
    String codonsNew() {
        char[] codonChars = this.codonsOld.toLowerCase().toCharArray();
        char snpBase = this.seqChange.netChange(this.transcript.getStrand()).charAt(0);
        codonChars[this.codonIndex] = Character.toUpperCase(snpBase);
        String codonsNew = new String(codonChars);
        return codonsNew;
    }

    @Override
    public String codonsOld() {
        int len;
        int maxBase;
        int numCodons = 1;
        int minBase = this.codonNum * 3;
        if (minBase < 0) {
            minBase = 0;
        }
        if ((maxBase = this.codonNum * 3 + numCodons * 3) > (len = this.transcript.cds().length())) {
            maxBase = len;
        }
        char[] codonChars = this.transcript.cds().substring(minBase, maxBase).toLowerCase().toCharArray();
        codonChars[this.codonIndex] = Character.toUpperCase(codonChars[this.codonIndex]);
        String codon = new String(codonChars);
        return codon;
    }
}

