/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class CodonChangeIns
extends CodonChange {
    public CodonChangeIns(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        super(seqChange, transcript, changeEffect);
        this.returnNow = true;
    }

    @Override
    boolean codonChangeSingle(ChangeEffect changeEffect, Exon exon) {
        String netChange;
        if (this.seqChange.toString().equals("chr1:526_*/+CGGTCA")) {
            Gpr.debug("!!!");
        }
        if ((netChange = this.seqChange.netChange(this.transcript.getStrand())).length() % 3 != 0) {
            changeEffect.setCodons("", netChange, this.codonNum, this.codonIndex);
            changeEffect.set(this.transcript, ChangeEffect.EffectType.FRAME_SHIFT, "");
        } else if (this.codonIndex == 0) {
            changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_INSERTION, "");
            changeEffect.setCodons("", netChange, this.codonNum, this.codonIndex);
        } else {
            this.codonsOld = this.codonsOld();
            this.codonsNew = this.codonsNew();
            if (this.codonsNew.toUpperCase().startsWith(this.codonsOld.toUpperCase())) {
                changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_INSERTION, "");
                changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
            } else {
                changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_CHANGE_PLUS_CODON_INSERTION, "");
                changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
            }
        }
        return true;
    }

    @Override
    String codonsNew() {
        return String.valueOf(this.codonsOld.substring(0, this.codonIndex)) + this.seqChange.netChange(this.transcript.getStrand()) + this.codonsOld.substring(this.codonIndex);
    }
}

