/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Genes
implements Iterable<Gene>,
Serializable {
    private static final long serialVersionUID = 9022385501946879197L;
    public boolean debug = false;
    Genome genome;
    HashMap<String, Gene> genesById = new HashMap();

    public Genes(Genome genome) {
        this.genome = genome;
    }

    public void add(Gene gene) {
        this.genesById.put(gene.getId(), gene);
    }

    public List<Marker> createUpDownStream(int upDownLength) {
        ArrayList<Marker> list2 = new ArrayList<Marker>();
        if (upDownLength <= 0) {
            return list2;
        }
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createUpDownStream(upDownLength);
                list2.add(tr.getUpstream());
                list2.add(tr.getDownstream());
            }
        }
        return list2;
    }

    public Collection<Marker> findSpliceSites(boolean createIfMissing) {
        HashMap<String, SpliceSite> map2 = new HashMap<String, SpliceSite>();
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                List<SpliceSite> slist = tr.findSpliceSites(createIfMissing);
                for (SpliceSite ss : slist) {
                    String key = String.valueOf(ss.getClass().getSimpleName()) + " " + ss.getChromosomeName() + ":" + ss.getStart() + "-" + ss.getEnd() + "_" + ss.getId();
                    map2.put(key, ss);
                }
            }
        }
        return map2.values();
    }

    public Gene get(String geneId) {
        return this.genesById.get(geneId);
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genesById.values().iterator();
    }

    public int size() {
        return this.genesById.size();
    }

    public Collection<Gene> sorted() {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        genes.addAll(this.genesById.values());
        Collections.sort(genes, new IntervalComparatorByStart());
        return genes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Gene gint : this) {
            sb.append(gint + "\n");
        }
        return sb.toString();
    }

    public Collection<Gene> values() {
        return this.genesById.values();
    }
}

