/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class GenBank
extends Features {
    public static final int FEATURE_NAME_FIELD_LEN = 20;

    public GenBank(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        return !line.substring(0, 20).trim().isEmpty();
    }

    protected void parseFieldLine(String name, String valueOri, int fieldLineNum) {
        String value2 = valueOri.trim();
        if (name.equals("LOCUS")) {
            String[] subfields = value2.split(" ");
            this.locusName = subfields[0];
            if (subfields.length > 1) {
                this.sequenceLength = Gpr.parseIntSafe(subfields[1]);
            }
            if (subfields.length > 2) {
                this.moleculeType = subfields[2];
            }
            if (subfields.length > 3) {
                this.shape = subfields[3];
            }
            if (subfields.length > 4) {
                this.division = subfields[4];
            }
            if (subfields.length > 5) {
                this.date = subfields[5];
            }
        } else if (name.equals("DEFINITION")) {
            this.definition = String.valueOf(this.definition) + value2;
        } else if (name.equals("ACCESSION")) {
            this.accession = String.valueOf(this.accession) + value2;
        } else if (name.equals("VERSION")) {
            this.version = String.valueOf(this.version) + value2;
        } else if (name.equals("KEYWORDS")) {
            this.keywords = String.valueOf(this.keywords) + value2;
        } else if (name.equals("SOURCE")) {
            this.source = String.valueOf(this.source) + value2;
        } else if (name.equals("REFERENCE")) {
            if (fieldLineNum == 0) {
                this.references.add(new StringBuffer());
            }
            ((StringBuffer)this.references.get(this.references.size() - 1)).append(String.valueOf(value2) + "\n");
        } else if (name.equals("FEATURES")) {
            if (fieldLineNum > 0) {
                this.featuresStr.append(String.valueOf(valueOri) + "\n");
            }
        } else if (name.equals("ORIGIN")) {
            String[] seq2 = value2.split(" ", 2);
            if (seq2.length > 1) {
                String s = seq2[1].replaceAll(" ", "");
                this.sequence.append(s);
            }
        } else {
            System.err.println("Ignored feature '" + name + "'");
        }
    }

    @Override
    public void readFile(String fileName) {
        String fileTxt = Gpr.readFile(fileName);
        int fieldLineNum = 0;
        String name = null;
        String value2 = "";
        String[] stringArray = fileTxt.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] kv;
            String line;
            value2 = line = stringArray[n2];
            if (!line.startsWith(" ") && (kv = line.split(" ", 2)).length > 1) {
                name = kv[0];
                value2 = kv[1];
                fieldLineNum = 0;
            }
            this.parseFieldLine(name, value2, fieldLineNum);
            ++fieldLineNum;
            ++n2;
        }
        this.parseFeatures();
    }
}

