/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class Embl
extends Features {
    public static final int FEATURE_NAME_LEN = 15;
    public static final int FEATURE_KEY_LEN = 5;

    public Embl(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        return !line.substring(0, 15).trim().isEmpty();
    }

    protected void parseFieldLine(String fkey, String valueOri) {
        String value2 = valueOri.trim();
        if (!fkey.equals("XX")) {
            if (fkey.equals("ID")) {
                String[] subfields = value2.split(";");
                this.locusName = subfields[0];
                if (subfields.length > 1) {
                    this.shape = subfields[1];
                }
                if (subfields.length > 2) {
                    this.moleculeType = subfields[2];
                }
            } else if (fkey.equals("DT")) {
                this.date = value2;
            } else if (fkey.equals("DT")) {
                this.date = value2;
            } else if (fkey.equals("DE")) {
                this.definition = String.valueOf(this.definition) + value2;
            } else if (fkey.equals("AC")) {
                this.accession = String.valueOf(this.accession) + value2;
            } else if (fkey.equals("KW")) {
                this.keywords = String.valueOf(this.keywords) + value2;
            } else if (fkey.equals("OS") | fkey.equals("OC")) {
                this.organism = String.valueOf(this.organism) + value2;
            } else if (fkey.equals("FT")) {
                this.featuresStr.append(String.valueOf(valueOri) + "\n");
            } else if (!fkey.equals("//")) {
                if (fkey.startsWith("R")) {
                    if (fkey.equals("RN")) {
                        this.references.add(new StringBuffer());
                    }
                    ((StringBuffer)this.references.get(this.references.size() - 1)).append(String.valueOf(value2) + "\n");
                } else if (fkey.isEmpty()) {
                    String seq2 = value2.replaceAll("[ 0-9]", "");
                    this.sequence.append(seq2);
                } else if (!(fkey.equals("FH") | fkey.equals("PR") | fkey.equals("DR") | fkey.equals("CC") | fkey.equals("AH") | fkey.equals("AS") | fkey.equals("SQ"))) {
                    System.err.println("Unknown feature '" + fkey + "'");
                }
            }
        }
    }

    @Override
    public void readFile(String fileName) {
        String fileTxt = Gpr.readFile(fileName);
        String[] stringArray = fileTxt.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String fkey = "";
            String value2 = "";
            if (line.length() < 5) {
                fkey = line;
            } else {
                fkey = line.substring(0, 5).trim();
                value2 = line.substring(5);
            }
            this.parseFieldLine(fkey, value2);
            ++n2;
        }
        this.parseFeatures();
    }
}

