/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;

public abstract class MarkerFileIterator<M extends Marker>
extends FileIterator<M> {
    boolean createChromos = false;
    protected Genome genome;
    protected boolean ignoreChromosomeErrors = true;
    protected int inOffset;

    public MarkerFileIterator(BufferedReader reader, int inOffset) {
        super(reader);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
        this.createChromos = true;
    }

    public MarkerFileIterator(String fileName, Genome genome, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = genome;
    }

    public MarkerFileIterator(String fileName, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
        this.createChromos = true;
    }

    public Chromosome getChromosome(String chromoName) {
        if (this.createChromos) {
            return this.genome.getOrCreateChromosome(chromoName);
        }
        return this.genome.getChromosome(chromoName);
    }

    public Genome getGenome() {
        return this.genome;
    }

    public boolean isIgnoreChromosomeErrors() {
        return this.ignoreChromosomeErrors;
    }

    public int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    public void sanityCheckChromo(String chromoName, Chromosome chromo) {
        if (chromo == null) {
            if (this.ignoreChromosomeErrors) {
                System.err.println("WARNING: Chromosome '" + chromoName + "' not found. File '" + this.fileName + "', line " + this.lineNum);
                return;
            }
            throw new RuntimeException("ERROR: Chromosome '" + chromoName + "' not found! File '" + this.fileName + "', line " + this.lineNum);
        }
    }

    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setIgnoreChromosomeErrors(boolean ignoreChromosomeErrors) {
        this.ignoreChromosomeErrors = ignoreChromosomeErrors;
    }

    public void setInOffset(int inOffset) {
        this.inOffset = inOffset;
    }
}

