/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import java.util.HashMap;
import java.util.Map;

public enum FastqVariant {
    FASTQ_SANGER("Original or Sanger format"),
    FASTQ_SOLEXA("Solexa and early Illumina format"),
    FASTQ_ILLUMINA("Illumina 1.3+ format");

    private static final Map<String, FastqVariant> FASTQ_VARIANTS;
    private final String description;

    static {
        FASTQ_VARIANTS = new HashMap<String, FastqVariant>(6);
        FastqVariant[] fastqVariantArray = FastqVariant.values();
        int n = fastqVariantArray.length;
        int n2 = 0;
        while (n2 < n) {
            FastqVariant fastqVariant = fastqVariantArray[n2];
            FASTQ_VARIANTS.put(fastqVariant.name(), fastqVariant);
            FASTQ_VARIANTS.put(fastqVariant.lowercaseName(), fastqVariant);
            ++n2;
        }
    }

    public static FastqVariant parseFastqVariant(String name) {
        return FASTQ_VARIANTS.get(name);
    }

    private FastqVariant(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIllumina() {
        return this == FASTQ_ILLUMINA;
    }

    public boolean isSanger() {
        return this == FASTQ_SANGER;
    }

    public boolean isSolexa() {
        return this == FASTQ_SOLEXA;
    }

    public String lowercaseName() {
        return this.name().toLowerCase().replace('_', '-');
    }
}

