/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqTools;
import ca.mcgill.mcb.pcingola.fastq.FastqTrimmer;
import java.util.Collections;
import java.util.LinkedList;

public class FastqTrimmerMedian
extends FastqTrimmer {
    int runningMedianLength;

    public FastqTrimmerMedian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases);
        this.runningMedianLength = runningMedianLength;
    }

    int median(int[] qual, int i) {
        LinkedList<Integer> list2 = new LinkedList<Integer>();
        int k = 0;
        int j = i - this.runningMedianLength + 1;
        while (k < this.runningMedianLength) {
            if (j >= 0 && j < qual.length) {
                list2.add(qual[j]);
            }
            ++k;
            ++j;
        }
        Collections.sort(list2);
        int size2 = list2.size();
        int med = 0;
        med = list2.size() % 2 == 1 ? (Integer)list2.get(size2 / 2) : ((Integer)list2.get(size2 / 2 - 1) + (Integer)list2.get(size2 / 2)) / 2;
        return med;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        int i = 0;
        while (i < qual.length) {
            int median = this.median(qual, i);
            if (median < this.qualityThreshold) {
                return i;
            }
            ++i;
        }
        return qual.length;
    }
}

