/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqTools;
import ca.mcgill.mcb.pcingola.fastq.FastqTrimmerMedian;
import java.util.Collections;
import java.util.LinkedList;

public class FastqTrimmerAdrian
extends FastqTrimmerMedian {
    public FastqTrimmerAdrian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases, runningMedianLength);
        this.minBases = minBases;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        int i = 0;
        while (i < qual.length - this.runningMedianLength) {
            LinkedList<Integer> list2 = new LinkedList<Integer>();
            int k = 1;
            while (k <= this.runningMedianLength) {
                list2.add(qual[i + k]);
                ++k;
            }
            Collections.sort(list2);
            int size2 = list2.size();
            int med = 0;
            med = list2.size() % 2 == 1 ? (Integer)list2.get(size2 / 2) : ((Integer)list2.get(size2 / 2 - 1) + (Integer)list2.get(size2 / 2)) / 2;
            if (med < this.qualityThreshold) break;
            i += 2;
        }
        if ((i -= this.runningMedianLength - 1) > this.minBases) {
            return i;
        }
        return 0;
    }
}

