/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqBuilder;
import ca.mcgill.mcb.pcingola.fastq.FastqTools;

public class FastqTrimmer {
    public static boolean debug = false;
    int qualityThreshold;
    FastqBuilder fastqBuilder;
    int minBases;

    public FastqTrimmer(int qualityThreshold, int minBases) {
        this.qualityThreshold = qualityThreshold;
        this.minBases = minBases;
        this.fastqBuilder = new FastqBuilder();
    }

    public Fastq trim(Fastq fastq) {
        int idx = this.trimIndex(fastq);
        if (idx < this.minBases) {
            idx = 0;
        }
        this.fastqBuilder.withDescription(fastq.getDescription());
        this.fastqBuilder.withVariant(fastq.getVariant());
        this.fastqBuilder.withSequence(fastq.getSequence().substring(0, idx));
        this.fastqBuilder.withQuality(fastq.getQuality().substring(0, idx));
        return this.fastqBuilder.build();
    }

    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        int i = 0;
        while (i < qual.length) {
            if (qual[i] < this.qualityThreshold) {
                return i;
            }
            ++i;
        }
        return qual.length;
    }
}

