/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.collections;

import ca.mcgill.mcb.pcingola.collections.ArrayUtil;
import ca.mcgill.mcb.pcingola.collections.BitUtil;
import java.io.Serializable;
import java.util.Arrays;

public class OpenBitSet
implements Cloneable,
Serializable {
    protected long[] bits;
    protected int wlen;

    public static long andNotCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_andnot(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public static long intersectionCount(OpenBitSet a, OpenBitSet b) {
        return BitUtil.pop_intersect(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
    }

    public static long unionCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_union(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static long xorCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_xor(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public OpenBitSet() {
        this(64L);
    }

    public OpenBitSet(long numBits) {
        this.bits = new long[OpenBitSet.bits2words(numBits)];
        this.wlen = this.bits.length;
    }

    public OpenBitSet(long[] bits2, int numWords) {
        this.bits = bits2;
        this.wlen = numWords;
    }

    public void and(OpenBitSet other) {
        this.intersect(other);
    }

    public void andNot(OpenBitSet other) {
        this.remove(other);
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public void clear(long index2) {
        int wordNum = (int)(index2 >> 6);
        if (wordNum >= this.wlen) {
            return;
        }
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public Object clone() {
        try {
            OpenBitSet obs = (OpenBitSet)super.clone();
            obs.bits = (long[])obs.bits.clone();
            return obs;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(OpenBitSet.bits2words(numBits));
    }

    public void ensureCapacityWords(int numWords) {
        if (this.bits.length < numWords) {
            this.bits = ArrayUtil.grow(this.bits, numWords);
        }
    }

    public boolean equals(Object o) {
        OpenBitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet b = (OpenBitSet)o;
        if (b.wlen > this.wlen) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        int i = a.wlen - 1;
        while (i >= b.wlen) {
            if (a.bits[i] != 0L) {
                return false;
            }
            --i;
        }
        i = b.wlen - 1;
        while (i >= 0) {
            if (a.bits[i] != b.bits[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected int expandingWordNum(long index2) {
        int wordNum = (int)(index2 >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index2 + 1L);
            this.wlen = wordNum + 1;
        }
        return wordNum;
    }

    public void fastClear(int index2) {
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastClear(long index2) {
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastFlip(int index2) {
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void fastFlip(long index2) {
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public boolean fastGet(int index2) {
        int i = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean fastGet(long index2) {
        int i = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public void fastSet(int index2) {
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void fastSet(long index2) {
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void flip(long index2) {
        int wordNum = this.expandingWordNum(index2);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        int i = startWord + 1;
        while (i < endWord) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public boolean flipAndGet(int index2) {
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public boolean flipAndGet(long index2) {
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public boolean get(int index2) {
        int i = index2 >> 6;
        if (i >= this.bits.length) {
            return false;
        }
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean get(long index2) {
        int i = (int)(index2 >> 6);
        if (i >= this.bits.length) {
            return false;
        }
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean getAndSet(int index2) {
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public boolean getAndSet(long index2) {
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public int getBit(int index2) {
        int i = index2 >> 6;
        int bit = index2 & 0x3F;
        return (int)(this.bits[i] >>> bit) & 1;
    }

    public long[] getBits() {
        return this.bits;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public int hashCode() {
        long h = 0L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    public void intersect(OpenBitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = newLen;
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.wlen > newLen) {
            Arrays.fill(this.bits, newLen, this.wlen, 0L);
        }
        this.wlen = newLen;
    }

    public boolean intersects(OpenBitSet other) {
        int pos = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--pos >= 0) {
            if ((thisArr[pos] & otherArr[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    /*
     * Unable to fully structure code
     */
    public int nextSetBit(int index) {
        i = index >> 6;
        if (i >= this.wlen) {
            return -1;
        }
        subIndex = index & 63;
        word = this.bits[i] >> subIndex;
        if (word == 0L) ** GOTO lbl11
        return (i << 6) + subIndex + BitUtil.ntz(word);
lbl-1000:
        // 1 sources

        {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + BitUtil.ntz(word);
lbl11:
            // 2 sources

            ** while (++i < this.wlen)
        }
lbl12:
        // 1 sources

        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public long nextSetBit(long index) {
        i = (int)(index >>> 6);
        if (i >= this.wlen) {
            return -1L;
        }
        subIndex = (int)index & 63;
        word = this.bits[i] >>> subIndex;
        if (word == 0L) ** GOTO lbl11
        return ((long)i << 6) + (long)(subIndex + BitUtil.ntz(word));
lbl-1000:
        // 1 sources

        {
            word = this.bits[i];
            if (word == 0L) continue;
            return ((long)i << 6) + (long)BitUtil.ntz(word);
lbl11:
            // 2 sources

            ** while (++i < this.wlen)
        }
lbl12:
        // 1 sources

        return -1L;
    }

    public void or(OpenBitSet other) {
        this.union(other);
    }

    public void remove(OpenBitSet other) {
        int idx = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--idx >= 0) {
            int n = idx;
            thisArr[n] = thisArr[n] & (otherArr[idx] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void set(long index2) {
        int wordNum = this.expandingWordNum(index2);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    public void setBits(long[] bits2) {
        this.bits = bits2;
    }

    public void setNumWords(int nWords) {
        this.wlen = nWords;
    }

    public long size() {
        return this.capacity();
    }

    public void trimTrailingZeros() {
        int idx = this.wlen - 1;
        while (idx >= 0 && this.bits[idx] == 0L) {
            --idx;
        }
        this.wlen = idx + 1;
    }

    public void union(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void xor(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] ^ otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }
}

