/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.codons;

import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class CodonTable {
    String name;
    HashMap<String, String> codon2aa;
    HashMap<String, String> aa2codon;
    HashSet<String> startCodons;
    HashSet<String> stopCodons;
    HashMap<String, Integer> degeneracy;

    public CodonTable(String name, String table) {
        this.name = name;
        this.codon2aa = new HashMap();
        this.aa2codon = new HashMap();
        this.startCodons = new HashSet();
        this.stopCodons = new HashSet();
        this.parse(table);
        this.calcDegeneracy();
    }

    public String aa(String codons) {
        char[] bases = codons.toCharArray();
        StringBuilder aas = new StringBuilder();
        int i = 0;
        while (i < bases.length) {
            String cod = "";
            int j = 0;
            while (j < 3 && i < bases.length) {
                cod = String.valueOf(cod) + bases[i];
                ++j;
                ++i;
            }
            String aa = this.codon2aa.get(cod.toUpperCase());
            if (aa == null) {
                aa = "?";
            }
            aas.append(aa);
        }
        return aas.toString();
    }

    void calcDegeneracy() {
        this.degeneracy = new HashMap();
        char[] cArray = DnaCoder.TO_BASE;
        int n = DnaCoder.TO_BASE.length;
        int n2 = 0;
        while (n2 < n) {
            char base1 = cArray[n2];
            char[] cArray2 = DnaCoder.TO_BASE;
            int n3 = DnaCoder.TO_BASE.length;
            int n4 = 0;
            while (n4 < n3) {
                char base2 = cArray2[n4];
                char[] cArray3 = DnaCoder.TO_BASE;
                int n5 = DnaCoder.TO_BASE.length;
                int n6 = 0;
                while (n6 < n5) {
                    char base3 = cArray3[n6];
                    char[] c = new char[]{base1, base2, base3};
                    String codonStrOld = new String(c);
                    String aaOld = this.aa(codonStrOld);
                    int pos = 0;
                    while (pos < 3) {
                        int count2 = 0;
                        char[] cArray4 = DnaCoder.TO_BASE;
                        int n7 = DnaCoder.TO_BASE.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            char baseNew = cArray4[n8];
                            char[] codon = new char[]{base1, base2, base3};
                            codon[pos] = baseNew;
                            String codonStrNew = new String(codon);
                            String aaNew = this.aa(codonStrNew);
                            if (aaOld.equals(aaNew)) {
                                ++count2;
                            }
                            ++n8;
                        }
                        String key = String.valueOf(codonStrOld.toUpperCase()) + "_" + pos;
                        this.degeneracy.put(key, count2);
                        ++pos;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String codon(String aa) {
        String codon = this.aa2codon.get(aa.toUpperCase());
        if (codon == null) {
            return "???";
        }
        return codon;
    }

    public int degenerate(String codon, int pos) {
        String key = String.valueOf(codon.toUpperCase()) + "_" + pos;
        Integer degLevel = this.degeneracy.get(key);
        return degLevel != null ? degLevel : -1;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStart(String codon) {
        if (codon.length() == 3) {
            return this.startCodons.contains(codon.toUpperCase());
        }
        int i = 0;
        while (i < codon.length()) {
            int max2 = Math.min(codon.length(), i + 3);
            String codonSigle = codon.substring(i, max2);
            if (this.startCodons.contains(codonSigle.toUpperCase())) {
                return true;
            }
            i += 3;
        }
        return false;
    }

    public boolean isStartFirst(String codon) {
        if (codon.length() < 3) {
            return false;
        }
        return this.isStart(codon.substring(0, 3));
    }

    public boolean isStop(String codon) {
        if (codon.length() == 3) {
            return this.stopCodons.contains(codon.toUpperCase());
        }
        int i = 0;
        while (i < codon.length()) {
            int max2 = Math.min(codon.length(), i + 3);
            String codonSigle = codon.substring(i, max2);
            if (this.stopCodons.contains(codonSigle.toUpperCase())) {
                return true;
            }
            i += 3;
        }
        return false;
    }

    void parse(String table) {
        String[] entries;
        table = table.toUpperCase();
        String[] stringArray = entries = table.split(",");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if ((entry = entry.trim()).length() > 0) {
                String[] t2 = entry.split("/");
                if (t2.length == 2) {
                    String codon = t2[0];
                    String aa = t2[1];
                    if (aa.indexOf(43) >= 0) {
                        this.startCodons.add(codon);
                        aa = aa.replaceAll("\\+", "");
                    }
                    if (aa.indexOf(42) >= 0) {
                        this.stopCodons.add(codon);
                    }
                    this.aa2codon.put(aa, codon);
                    this.codon2aa.put(codon, aa);
                } else {
                    throw new RuntimeException("Error reading codon table. Cannot parse entry: '" + entry + "'\n\tTable: '" + table + "'");
                }
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("codon." + this.name + ": ");
        ArrayList<String> codons = new ArrayList<String>();
        codons.addAll(this.codon2aa.keySet());
        Collections.sort(codons);
        for (String codon : codons) {
            sb.append(" " + codon + "/" + this.aa(codon) + (this.isStart(codon) ? "+" : "") + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

