/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.chisquare;
import DistLib.misc;

public class noncentral_chisquare {
    public static double density(double x2, double df, double lambda) {
        int maxiter = 100;
        double eps = 1.0E-14;
        if (Double.isNaN(x2) || Double.isNaN(df) || Double.isNaN(lambda)) {
            return x2 + df + lambda;
        }
        if (lambda < 0.0 || df <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(df) || Double.isInfinite(lambda)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        double dens = chisquare.density(x2, df);
        if (lambda == 0.0) {
            return dens;
        }
        double lambda2 = 0.5 * lambda;
        double weight = Math.exp(-lambda2);
        double sum2 = weight * dens;
        double psum = weight;
        double i = 1.0;
        while (i < 100.0) {
            dens = x2 / df * dens;
            df += 2.0;
            weight = weight * lambda2 / i;
            sum2 += dens * weight;
            if (1.0 - (psum += weight) < 1.0E-14) break;
            i += 1.0;
        }
        return sum2;
    }

    public static double cumulative(double x2, double f2, double theta) {
        double bound;
        double term;
        double u;
        double errmax = 1.0E-12;
        double zero2 = 0.0;
        double half = 0.5;
        int itrmax = 100;
        if (Double.isNaN(x2) || Double.isNaN(f2) || Double.isNaN(theta)) {
            return x2 + f2 + theta;
        }
        if (Double.isInfinite(f2) || Double.isInfinite(theta)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (f2 < 0.0 && theta < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 1.0;
        }
        double lam = theta * 0.5;
        double v = u = Math.exp(-lam);
        double x22 = x2 * 0.5;
        double f22 = f2 / 0.5;
        double t2 = Math.exp(f22 * Math.log(x22) - x22 - misc.lgammafn(f22 + 1.0));
        double ans = term = v * t2;
        boolean flag = false;
        int n = 1;
        double twon = n * 2;
        while (!(f2 + twon - x2 > 0.0)) {
            term = (v += (u *= lam / (double)n)) * (t2 *= x2 / (f2 + twon));
            ans += term;
            twon = ++n * 2;
        }
        flag = true;
        while (!((bound = t2 * x2 / (f2 + twon - x2)) <= 1.0E-12) && n <= 100) {
            term = (v += (u *= lam / (double)n)) * (t2 *= x2 / (f2 + twon));
            ans += term;
            twon = ++n * 2;
        }
        if (bound > 1.0E-12) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        return ans;
    }

    public static double quantile(double p, double n, double lambda) {
        double nx;
        double acu = 1.0E-12;
        if (Double.isNaN(p) || Double.isNaN(n) || Double.isNaN(lambda)) {
            return p + n + lambda;
        }
        if (Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        n = Math.floor(n + 0.5);
        if (p < 0.0 || p >= 1.0 || n < 1.0 || lambda < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p == 0.0) {
            return 0.0;
        }
        double ux = 1.0;
        while (noncentral_chisquare.cumulative(ux, n, lambda) < p) {
            ux *= 2.0;
        }
        double lx = ux;
        while (noncentral_chisquare.cumulative(lx, n, lambda) > p) {
            lx *= 0.5;
        }
        do {
            if (noncentral_chisquare.cumulative(nx = 0.5 * (lx + ux), n, lambda) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while ((ux - lx) / nx > acu);
        return 0.5 * (ux + lx);
    }
}

