/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.liftover.LiftOver;
import net.sf.picard.util.Interval;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.StandardVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class LiftoverVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected File file = null;
    protected StandardVCFWriter writer = null;
    @Argument(fullName="chain", shortName="chain", doc="Chain file", required=true)
    protected File CHAIN = null;
    @Argument(fullName="newSequenceDictionary", shortName="dict", doc="Sequence .dict file for the new build", required=true)
    protected File NEW_SEQ_DICT = null;
    @Argument(fullName="recordOriginalLocation", shortName="recordOriginalLocation", doc="Should we record what the original location was in the INFO field?", required=false)
    protected Boolean RECORD_ORIGINAL_LOCATION = false;
    private LiftOver liftOver;
    private long successfulIntervals = 0L;
    private long failedIntervals = 0L;

    @Override
    public void initialize() {
        try {
            this.liftOver = new LiftOver(this.CHAIN);
        }
        catch (RuntimeException e) {
            throw new UserException.BadInput("there is a problem with the chain file you are using: " + e.getMessage());
        }
        this.liftOver.setLiftOverMinMatch(0.95);
        try {
            SAMFileHeader toHeader = new SAMFileReader(this.NEW_SEQ_DICT).getFileHeader();
            this.liftOver.validateToSequences(toHeader.getSequenceDictionary());
        }
        catch (RuntimeException e) {
            throw new UserException.BadInput("the chain file you are using is not compatible with the reference you are trying to lift over to; please use the appropriate chain file for the given reference");
        }
        String trackName = this.variantCollection.variants.getName();
        Set samples = SampleUtils.getSampleListWithVCFHeader((GenomeAnalysisEngine)this.getToolkit(), Arrays.asList(trackName));
        Map vcfHeaders = VCFUtils.getVCFHeadersFromRods((GenomeAnalysisEngine)this.getToolkit(), Arrays.asList(trackName));
        HashSet<VCFInfoHeaderLine> metaData = new HashSet<VCFInfoHeaderLine>();
        if (vcfHeaders.containsKey(trackName)) {
            metaData.addAll(((VCFHeader)vcfHeaders.get(trackName)).getMetaData());
        }
        if (this.RECORD_ORIGINAL_LOCATION.booleanValue()) {
            metaData.add(new VCFInfoHeaderLine("OriginalChr", 1, VCFHeaderLineType.String, "Original contig name for the record"));
            metaData.add(new VCFInfoHeaderLine("OriginalStart", 1, VCFHeaderLineType.Integer, "Original start position for the record"));
        }
        VCFHeader vcfHeader = new VCFHeader(metaData, samples);
        this.writer = new StandardVCFWriter(this.file, this.getMasterSequenceDictionary(), false);
        this.writer.writeHeader(vcfHeader);
    }

    private void convertAndWrite(VariantContext vc, ReferenceContext ref) {
        Interval fromInterval = new Interval(vc.getChr(), vc.getStart(), vc.getStart(), false, String.format("%s:%d", vc.getChr(), vc.getStart()));
        int length = vc.getEnd() - vc.getStart();
        Interval toInterval = this.liftOver.liftOver(fromInterval);
        VariantContext originalVC = vc;
        if (toInterval != null) {
            if (fromInterval.isPositiveStrand() != toInterval.isPositiveStrand() && vc.isPointEvent()) {
                vc = VariantContextUtils.reverseComplement((VariantContext)vc);
            }
            vc = new VariantContextBuilder(vc).loc(toInterval.getSequence(), (long)toInterval.getStart(), (long)(toInterval.getStart() + length)).make();
            if (this.RECORD_ORIGINAL_LOCATION.booleanValue()) {
                vc = new VariantContextBuilder(vc).attribute("OriginalChr", (Object)fromInterval.getSequence()).attribute("OriginalStart", (Object)fromInterval.getStart()).make();
            }
            VariantContext newVC = VariantContextUtils.createVariantContextWithPaddedAlleles((VariantContext)vc, (boolean)false);
            if (originalVC.isSNP() && originalVC.isBiallelic() && VariantContextUtils.getSNPSubstitutionType((VariantContext)originalVC) != VariantContextUtils.getSNPSubstitutionType((VariantContext)newVC)) {
                logger.warn((Object)String.format("VCF at %s / %d => %s / %d is switching substitution type %s/%s to %s/%s", originalVC.getChr(), originalVC.getStart(), newVC.getChr(), newVC.getStart(), originalVC.getReference(), originalVC.getAlternateAllele(0), newVC.getReference(), newVC.getAlternateAllele(0)));
            }
            this.writer.add(vc);
            ++this.successfulIntervals;
        } else {
            ++this.failedIntervals;
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        for (VariantContext vc : VCs) {
            this.convertAndWrite(vc, ref);
        }
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer result) {
        System.out.println("Converted " + this.successfulIntervals + " records; failed to convert " + this.failedIntervals + " records.");
        this.writer.close();
    }
}

