/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.FrequencyModeSelector;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.GenomeEvent;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class UniformSamplingFrequencySelector
extends FrequencyModeSelector {
    private ArrayList<GenomeEvent> binnedEventArray = new ArrayList();

    public UniformSamplingFrequencySelector(GenomeLocParser parser) {
        super(parser);
    }

    @Override
    public void logCurrentSiteData(VariantContext vc, boolean selectedInTargetSamples, boolean IGNORE_GENOTYPES, boolean IGNORE_POLYMORPHIC) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (vc.hasGenotypes() && !IGNORE_GENOTYPES) {
            VariantContextUtils.calculateChromosomeCounts((VariantContext)vc, attributes, (boolean)false);
            if (!selectedInTargetSamples && !IGNORE_POLYMORPHIC) {
                return;
            }
        } else if (!IGNORE_POLYMORPHIC) {
            if (vc.getAttributes().containsKey("AC")) {
                int ac = vc.getAttributeAsInt("AC", 0);
                if (ac == 0) {
                    return;
                }
            } else {
                return;
            }
        }
        GenomeEvent event = new GenomeEvent(this.parser, vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), attributes, vc.getReferenceBaseForIndel());
        this.binnedEventArray.add(event);
    }

    @Override
    public ArrayList<VariantContext> selectValidationSites(int numValidationSites) {
        ArrayList selectedEvents = new ArrayList();
        selectedEvents.addAll(MathUtils.randomSubset(this.binnedEventArray, (int)numValidationSites));
        Collections.sort(selectedEvents);
        ArrayList<VariantContext> selectedSites = new ArrayList<VariantContext>();
        for (GenomeEvent event : selectedEvents) {
            selectedSites.add(event.createVariantContextFromEvent());
        }
        return selectedSites;
    }
}

