/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.BadMateFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_INPUT)
@ReadFilters(value={BadMateFilter.class, MappingQualityUnavailableFilter.class})
@Reference(window=@Window(start=-200, stop=200))
@By(value=DataSource.REFERENCE)
@Downsample(by=DownsampleType.BY_SAMPLE, toCoverage=250)
public class UnifiedGenotyper
extends LocusWalker<List<VariantCallContext>, UGStatistics>
implements TreeReducible<UGStatistics>,
AnnotatorCompatibleWalker {
    @ArgumentCollection
    private UnifiedArgumentCollection UAC = new UnifiedArgumentCollection();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(fullName="comp", shortName="comp", doc="comparison VCF file", required=false)
    public List<RodBinding<VariantContext>> comps = Collections.emptyList();
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    @Hidden
    @Argument(fullName="debug_file", shortName="debug_file", doc="File to print all of the annotated and detailed debugging output", required=false)
    protected PrintStream verboseWriter = null;
    @Hidden
    @Argument(fullName="metrics_file", shortName="metrics", doc="File to print any relevant callability metrics output", required=false)
    protected PrintStream metricsWriter = null;
    @Argument(fullName="annotation", shortName="A", doc="One or more specific annotations to apply to variant calls", required=false)
    protected List<String> annotationsToUse = new ArrayList<String>();
    @Argument(fullName="excludeAnnotation", shortName="XA", doc="One or more specific annotations to exclude", required=false)
    protected List<String> annotationsToExclude = new ArrayList<String>();
    @Argument(fullName="group", shortName="G", doc="One or more classes/groups of annotations to apply to variant calls", required=false)
    protected String[] annotationClassesToUse = new String[]{"Standard"};
    private UnifiedGenotyperEngine UG_engine = null;
    private VariantAnnotatorEngine annotationEngine;

    @Override
    public RodBinding<VariantContext> getDbsnpRodBinding() {
        return this.dbsnp.dbsnp;
    }

    @Override
    public List<RodBinding<VariantContext>> getCompRodBindings() {
        return this.comps;
    }

    @Override
    public RodBinding<VariantContext> getSnpEffRodBinding() {
        return null;
    }

    @Override
    public List<RodBinding<VariantContext>> getResourceRodBindings() {
        return Collections.emptyList();
    }

    @Override
    public boolean alwaysAppendDbsnpId() {
        return false;
    }

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public void initialize() {
        if (this.UAC.MAX_ALTERNATE_ALLELES > 50) {
            throw new UserException.BadArgumentValue("max_alternate_alleles", "the maximum possible value is 50");
        }
        if (this.UAC.OutputMode == UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY && this.UAC.GLmodel != GenotypeLikelihoodsCalculationModel.Model.SNP) {
            logger.warn((Object)"WARNING: note that the EMIT_ALL_SITES option is intended only for point mutations (SNPs) in DISCOVERY mode or generally when running in GENOTYPE_GIVEN_ALLELES mode; it will by no means produce a comprehensive set of indels in DISCOVERY mode");
        }
        Set samples = SampleUtils.getSAMFileSamples((SAMFileHeader)this.getToolkit().getSAMFileHeader());
        if (this.verboseWriter != null) {
            this.verboseWriter.println("AFINFO\tLOC\tREF\tALT\tMAF\tF\tAFprior\tMLE\tMAP");
        }
        this.annotationEngine = new VariantAnnotatorEngine(Arrays.asList(this.annotationClassesToUse), this.annotationsToUse, this.annotationsToExclude, this, this.getToolkit());
        this.UG_engine = new UnifiedGenotyperEngine(this.getToolkit(), this.UAC, logger, this.verboseWriter, this.annotationEngine, samples, 2);
        Set<VCFHeaderLine> headerInfo = this.getHeaderInfo();
        this.annotationEngine.invokeAnnotationInitializationMethods(headerInfo);
        this.writer.writeHeader(new VCFHeader(headerInfo, samples));
    }

    private Set<VCFHeaderLine> getHeaderInfo() {
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>();
        headerInfo.addAll(this.annotationEngine.getVCFAnnotationDescriptions());
        if (!this.UAC.NO_SLOD) {
            headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("SB", 1, VCFHeaderLineType.Float, "Strand Bias"));
        }
        if (this.UAC.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED) {
            headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("NDA", 1, VCFHeaderLineType.Integer, "Number of alternate alleles discovered (but not necessarily genotyped) at this site"));
        }
        headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("DS", 0, VCFHeaderLineType.Flag, "Were any of the samples downsampled?"));
        if (this.dbsnp.dbsnp.isBound()) {
            headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("DB", 0, VCFHeaderLineType.Flag, "dbSNP Membership"));
        }
        headerInfo.addAll(UnifiedGenotyper.getSupportedHeaderStrings());
        if (this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING < this.UAC.STANDARD_CONFIDENCE_FOR_CALLING) {
            headerInfo.add((VCFHeaderLine)new VCFFilterHeaderLine("LowQual", "Low quality"));
        }
        return headerInfo;
    }

    private static Set<VCFFormatHeaderLine> getSupportedHeaderStrings() {
        HashSet<VCFFormatHeaderLine> result = new HashSet<VCFFormatHeaderLine>();
        result.add(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        result.add(new VCFFormatHeaderLine("GQ", 1, VCFHeaderLineType.Float, "Genotype Quality"));
        result.add(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Approximate read depth (reads with MQ=255 or with bad mates are filtered)"));
        result.add(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        return result;
    }

    @Override
    public List<VariantCallContext> map(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        return this.UG_engine.calculateLikelihoodsAndGenotypes(tracker, refContext, rawContext);
    }

    @Override
    public UGStatistics reduceInit() {
        return new UGStatistics();
    }

    @Override
    public UGStatistics treeReduce(UGStatistics lhs, UGStatistics rhs) {
        lhs.nBasesCallable += rhs.nBasesCallable;
        lhs.nBasesCalledConfidently += rhs.nBasesCalledConfidently;
        lhs.nBasesVisited += rhs.nBasesVisited;
        lhs.nCallsMade += rhs.nCallsMade;
        return lhs;
    }

    @Override
    public UGStatistics reduce(List<VariantCallContext> calls, UGStatistics sum) {
        ++sum.nBasesVisited;
        boolean wasCallable = false;
        boolean wasConfidentlyCalled = false;
        for (VariantCallContext call : calls) {
            if (call == null) continue;
            wasCallable = true;
            wasConfidentlyCalled = call.confidentlyCalled;
            if (!call.shouldEmit) continue;
            try {
                ++sum.nCallsMade;
                this.writer.add((VariantContext)call);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (wasCallable) {
            ++sum.nBasesCallable;
        }
        if (wasConfidentlyCalled) {
            ++sum.nBasesCalledConfidently;
        }
        return sum;
    }

    @Override
    public void onTraversalDone(UGStatistics sum) {
        if (this.metricsWriter != null) {
            this.metricsWriter.println(String.format("Visited bases                                %d", sum.nBasesVisited));
            this.metricsWriter.println(String.format("Callable bases                               %d", sum.nBasesCallable));
            this.metricsWriter.println(String.format("Confidently called bases                     %d", sum.nBasesCalledConfidently));
            this.metricsWriter.println(String.format("%% callable bases of all loci                 %3.3f", sum.percentCallableOfAll()));
            this.metricsWriter.println(String.format("%% confidently called bases of all loci       %3.3f", sum.percentCalledOfAll()));
            this.metricsWriter.println(String.format("%% confidently called bases of callable loci  %3.3f", sum.percentCalledOfCallable()));
            this.metricsWriter.println(String.format("Actual calls made                            %d", sum.nCallsMade));
        }
    }

    public static class UGStatistics {
        long nBasesVisited = 0L;
        long nBasesCallable = 0L;
        long nBasesCalledConfidently = 0L;
        long nCallsMade = 0L;
        long nExtendedEvents = 0L;

        double percentCallableOfAll() {
            return 100.0 * (double)this.nBasesCallable / (double)(this.nBasesVisited - this.nExtendedEvents);
        }

        double percentCalledOfAll() {
            return 100.0 * (double)this.nBasesCalledConfidently / (double)(this.nBasesVisited - this.nExtendedEvents);
        }

        double percentCalledOfCallable() {
            return 100.0 * (double)this.nBasesCalledConfidently / (double)this.nBasesCallable;
        }
    }
}

