/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class ExactAFCalculationModel
extends AlleleFrequencyCalculationModel {
    private static final double MAX_LOG10_ERROR_TO_STOP_EARLY = 6.0;
    private static final int PL_INDEX_OF_HOM_REF = 0;
    private static final int HOM_REF_INDEX = 0;

    protected ExactAFCalculationModel(UnifiedArgumentCollection UAC, int N, Logger logger, PrintStream verboseWriter) {
        super(UAC, N, logger, verboseWriter);
    }

    @Override
    public List<Allele> getLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors, AlleleFrequencyCalculationResult result) {
        GenotypesContext GLs = vc.getGenotypes();
        ArrayList<Allele> alleles = vc.getAlleles();
        if (vc.getAlternateAlleles().size() > this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE) {
            this.logger.warn((Object)("this tool is currently set to genotype at most " + this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE + " alternate alleles in a given context, but the context at " + vc.getChr() + ":" + vc.getStart() + " has " + vc.getAlternateAlleles().size() + " alternate alleles so only the top alleles will be used; see the --max_alternate_alleles argument"));
            alleles = new ArrayList<Allele>(this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE + 1);
            alleles.add(vc.getReference());
            alleles.addAll(ExactAFCalculationModel.chooseMostLikelyAlternateAlleles(vc, this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE));
            GLs = VariantContextUtils.subsetDiploidAlleles((VariantContext)vc, alleles, (boolean)false);
        }
        ExactAFCalculationModel.linearExactMultiAllelic(GLs, alleles.size() - 1, log10AlleleFrequencyPriors, result);
        return alleles;
    }

    private static final List<Allele> chooseMostLikelyAlternateAlleles(VariantContext vc, int numAllelesToChoose) {
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        AlleleFrequencyCalculationModel.LikelihoodSum[] likelihoodSums = new AlleleFrequencyCalculationModel.LikelihoodSum[numOriginalAltAlleles];
        for (int i = 0; i < numOriginalAltAlleles; ++i) {
            likelihoodSums[i] = new AlleleFrequencyCalculationModel.LikelihoodSum(vc.getAlternateAllele(i));
        }
        ArrayList<double[]> GLs = ExactAFCalculationModel.getGLs(vc.getGenotypes());
        for (double[] likelihoods : GLs) {
            int PLindexOfBestGL = MathUtils.maxElementIndex((double[])likelihoods);
            if (PLindexOfBestGL == 0) continue;
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair((int)PLindexOfBestGL);
            if (alleles.alleleIndex1 != 0) {
                likelihoodSums[alleles.alleleIndex1 - 1].sum += likelihoods[PLindexOfBestGL] - likelihoods[0];
            }
            if (alleles.alleleIndex2 == 0 || alleles.alleleIndex2 == alleles.alleleIndex1) continue;
            likelihoodSums[alleles.alleleIndex2 - 1].sum += likelihoods[PLindexOfBestGL] - likelihoods[0];
        }
        Collections.sort(Arrays.asList(likelihoodSums));
        ArrayList<Allele> bestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (int i = 0; i < numAllelesToChoose; ++i) {
            bestAlleles.add(likelihoodSums[i].allele);
        }
        ArrayList<Allele> orderedBestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (Allele allele : vc.getAlternateAlleles()) {
            if (!bestAlleles.contains(allele)) continue;
            orderedBestAlleles.add(allele);
        }
        return orderedBestAlleles;
    }

    public static void linearExactMultiAllelic(GenotypesContext GLs, int numAlternateAlleles, double[] log10AlleleFrequencyPriors, AlleleFrequencyCalculationResult result) {
        ArrayList<double[]> genotypeLikelihoods = ExactAFCalculationModel.getGLs(GLs);
        int numSamples = genotypeLikelihoods.size() - 1;
        int numChr = 2 * numSamples;
        LinkedList<ExactACset> ACqueue = new LinkedList<ExactACset>();
        HashMap<ExactACcounts, ExactACset> indexesToACset = new HashMap<ExactACcounts, ExactACset>(numChr + 1);
        int[] zeroCounts = new int[numAlternateAlleles];
        ExactACset zeroSet = new ExactACset(numSamples + 1, new ExactACcounts(zeroCounts));
        ACqueue.add(zeroSet);
        indexesToACset.put(zeroSet.ACcounts, zeroSet);
        double maxLog10L = Double.NEGATIVE_INFINITY;
        while (!ACqueue.isEmpty()) {
            ExactACset set = (ExactACset)ACqueue.remove();
            double log10LofKs = ExactAFCalculationModel.calculateAlleleCountConformation(set, genotypeLikelihoods, maxLog10L, numChr, ACqueue, indexesToACset, log10AlleleFrequencyPriors, result);
            maxLog10L = Math.max(maxLog10L, log10LofKs);
            indexesToACset.remove(set.ACcounts);
        }
    }

    private static double calculateAlleleCountConformation(ExactACset set, ArrayList<double[]> genotypeLikelihoods, double maxLog10L, int numChr, LinkedList<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset, double[] log10AlleleFrequencyPriors, AlleleFrequencyCalculationResult result) {
        ExactAFCalculationModel.computeLofK(set, genotypeLikelihoods, log10AlleleFrequencyPriors, result);
        double log10LofK = set.log10Likelihoods[set.log10Likelihoods.length - 1];
        if (log10LofK < maxLog10L - 6.0) {
            return log10LofK;
        }
        int ACwiggle = numChr - set.getACsum();
        if (ACwiggle == 0) {
            return log10LofK;
        }
        int numAltAlleles = set.ACcounts.getCounts().length;
        for (int allele = 0; allele < numAltAlleles; ++allele) {
            int[] ACcountsClone = (int[])set.ACcounts.getCounts().clone();
            int n = allele;
            ACcountsClone[n] = ACcountsClone[n] + 1;
            int PLindex = GenotypeLikelihoods.calculatePLindex((int)0, (int)(allele + 1));
            ExactAFCalculationModel.updateACset(ACcountsClone, numChr, set, PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
        }
        if (ACwiggle > 1) {
            ArrayList<DependentSet> differentAlleles = new ArrayList<DependentSet>(numAltAlleles * numAltAlleles);
            ArrayList<DependentSet> sameAlleles = new ArrayList<DependentSet>(numAltAlleles);
            for (int allele_i = 0; allele_i < numAltAlleles; ++allele_i) {
                for (int allele_j = allele_i; allele_j < numAltAlleles; ++allele_j) {
                    int[] ACcountsClone = (int[])set.ACcounts.getCounts().clone();
                    int n = allele_i;
                    ACcountsClone[n] = ACcountsClone[n] + 1;
                    int n2 = allele_j;
                    ACcountsClone[n2] = ACcountsClone[n2] + 1;
                    int PLindex = GenotypeLikelihoods.calculatePLindex((int)(allele_i + 1), (int)(allele_j + 1));
                    if (allele_i == allele_j) {
                        sameAlleles.add(new DependentSet(ACcountsClone, PLindex));
                        continue;
                    }
                    differentAlleles.add(new DependentSet(ACcountsClone, PLindex));
                }
            }
            for (DependentSet dependent : differentAlleles) {
                ExactAFCalculationModel.updateACset(dependent.ACcounts, numChr, set, dependent.PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
            }
            for (DependentSet dependent : sameAlleles) {
                ExactAFCalculationModel.updateACset(dependent.ACcounts, numChr, set, dependent.PLindex, ACqueue, indexesToACset, genotypeLikelihoods);
            }
        }
        return log10LofK;
    }

    private static void updateACset(int[] newSetCounts, int numChr, ExactACset dependentSet, int PLsetIndex, Queue<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset, ArrayList<double[]> genotypeLikelihoods) {
        ExactACcounts index = new ExactACcounts(newSetCounts);
        if (!indexesToACset.containsKey(index)) {
            ExactACset set = new ExactACset(numChr / 2 + 1, index);
            indexesToACset.put(index, set);
            ACqueue.add(set);
        }
        ExactAFCalculationModel.pushData(indexesToACset.get(index), dependentSet, PLsetIndex, genotypeLikelihoods);
    }

    private static void computeLofK(ExactACset set, ArrayList<double[]> genotypeLikelihoods, double[] log10AlleleFrequencyPriors, AlleleFrequencyCalculationResult result) {
        set.log10Likelihoods[0] = 0.0;
        int totalK = set.getACsum();
        if (totalK == 0) {
            for (int j = 1; j < set.log10Likelihoods.length; ++j) {
                set.log10Likelihoods[j] = set.log10Likelihoods[j - 1] + genotypeLikelihoods.get(j)[0];
            }
            double log10Lof0 = set.log10Likelihoods[set.log10Likelihoods.length - 1];
            result.setLog10LikelihoodOfAFzero(log10Lof0);
            result.setLog10PosteriorOfAFzero(log10Lof0 + log10AlleleFrequencyPriors[0]);
            return;
        }
        for (int j = 1; j < set.log10Likelihoods.length; ++j) {
            if (totalK < 2 * j - 1) {
                double[] gl = genotypeLikelihoods.get(j);
                double conformationValue = MathUtils.log10Cache[2 * j - totalK] + MathUtils.log10Cache[2 * j - totalK - 1] + set.log10Likelihoods[j - 1] + gl[0];
                set.log10Likelihoods[j] = MathUtils.approximateLog10SumLog10((double)set.log10Likelihoods[j], (double)conformationValue);
            }
            double logDenominator = MathUtils.log10Cache[2 * j] + MathUtils.log10Cache[2 * j - 1];
            set.log10Likelihoods[j] = set.log10Likelihoods[j] - logDenominator;
        }
        double log10LofK = set.log10Likelihoods[set.log10Likelihoods.length - 1];
        result.updateMLEifNeeded(log10LofK, set.ACcounts.counts);
        for (int ACcount : set.ACcounts.getCounts()) {
            if (ACcount <= 0) continue;
            log10LofK += log10AlleleFrequencyPriors[ACcount];
        }
        result.updateMAPifNeeded(log10LofK, set.ACcounts.counts);
    }

    private static void pushData(ExactACset targetSet, ExactACset dependentSet, int PLsetIndex, ArrayList<double[]> genotypeLikelihoods) {
        int totalK = targetSet.getACsum();
        for (int j = 1; j < targetSet.log10Likelihoods.length; ++j) {
            if (totalK > 2 * j) continue;
            double[] gl = genotypeLikelihoods.get(j);
            double conformationValue = ExactAFCalculationModel.determineCoefficient(PLsetIndex, j, targetSet.ACcounts.getCounts(), totalK) + dependentSet.log10Likelihoods[j - 1] + gl[PLsetIndex];
            targetSet.log10Likelihoods[j] = MathUtils.approximateLog10SumLog10((double)targetSet.log10Likelihoods[j], (double)conformationValue);
        }
    }

    private static double determineCoefficient(int PLindex, int j, int[] ACcounts, int totalK) {
        double coeff;
        GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair((int)PLindex);
        if (alleles.alleleIndex1 == 0) {
            return MathUtils.log10Cache[2 * ACcounts[alleles.alleleIndex2 - 1]] + MathUtils.log10Cache[2 * j - totalK];
        }
        int k_i = ACcounts[alleles.alleleIndex1 - 1];
        if (alleles.alleleIndex1 == alleles.alleleIndex2) {
            coeff = MathUtils.log10Cache[k_i] + MathUtils.log10Cache[k_i - 1];
        } else {
            int k_j = ACcounts[alleles.alleleIndex2 - 1];
            coeff = MathUtils.log10Cache[2] + MathUtils.log10Cache[k_i] + MathUtils.log10Cache[k_j];
        }
        return coeff;
    }

    @Override
    public GenotypesContext subsetAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes, int ploidy) {
        return VariantContextUtils.subsetDiploidAlleles((VariantContext)vc, allelesToUse, (boolean)assignGenotypes);
    }

    private static final class DependentSet {
        public final int[] ACcounts;
        public final int PLindex;

        public DependentSet(int[] ACcounts, int PLindex) {
            this.ACcounts = ACcounts;
            this.PLindex = PLindex;
        }
    }

    private static final class ExactACset {
        final ExactACcounts ACcounts;
        final double[] log10Likelihoods;
        int sum = -1;

        public ExactACset(int size, ExactACcounts ACcounts) {
            this.ACcounts = ACcounts;
            this.log10Likelihoods = new double[size];
            Arrays.fill(this.log10Likelihoods, Double.NEGATIVE_INFINITY);
        }

        public int getACsum() {
            if (this.sum == -1) {
                this.sum = 0;
                for (int count : this.ACcounts.getCounts()) {
                    this.sum += count;
                }
            }
            return this.sum;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExactACset && this.ACcounts.equals(((ExactACset)obj).ACcounts);
        }
    }

    private static final class ExactACcounts {
        private final int[] counts;
        private int hashcode = -1;

        public ExactACcounts(int[] counts) {
            this.counts = counts;
        }

        public int[] getCounts() {
            return this.counts;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExactACcounts && Arrays.equals(this.counts, ((ExactACcounts)obj).counts);
        }

        public int hashCode() {
            if (this.hashcode == -1) {
                this.hashcode = Arrays.hashCode(this.counts);
            }
            return this.hashcode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.counts[0]);
            for (int i = 1; i < this.counts.length; ++i) {
                sb.append("/");
                sb.append(this.counts[i]);
            }
            return sb.toString();
        }
    }
}

