/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffValue;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class DiffNode
extends DiffValue {
    private Map<String, DiffElement> getElementMap() {
        return (Map)super.getValue();
    }

    private static Map<String, DiffElement> emptyElements() {
        return new HashMap<String, DiffElement>();
    }

    private DiffNode(Map<String, DiffElement> elements) {
        super(elements);
    }

    private DiffNode(DiffElement binding, Map<String, DiffElement> elements) {
        super(binding, elements);
    }

    public static DiffNode rooted(String name) {
        return DiffNode.empty(name, DiffElement.ROOT);
    }

    public static DiffNode empty(String name, DiffElement parent) {
        DiffNode df = new DiffNode(DiffNode.emptyElements());
        DiffElement elt = new DiffElement(name, parent, df);
        df.setBinding(elt);
        return df;
    }

    public static DiffNode empty(String name, DiffValue parent) {
        return DiffNode.empty(name, parent.getBinding());
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    public Collection<String> getElementNames() {
        return this.getElementMap().keySet();
    }

    public Collection<DiffElement> getElements() {
        return this.getElementMap().values();
    }

    private Collection<DiffElement> getElements(boolean atomicOnly) {
        ArrayList<DiffElement> elts = new ArrayList<DiffElement>();
        for (DiffElement elt : this.getElements()) {
            if ((!atomicOnly || !elt.getValue().isAtomic()) && (atomicOnly || !elt.getValue().isCompound())) continue;
            elts.add(elt);
        }
        return elts;
    }

    public Collection<DiffElement> getAtomicElements() {
        return this.getElements(true);
    }

    public Collection<DiffElement> getCompoundElements() {
        return this.getElements(false);
    }

    public DiffElement getElement(String name) {
        return this.getElementMap().get(name);
    }

    public boolean hasElement(String name) {
        return this.getElement(name) != null;
    }

    @Requires(value={"elt != null"})
    public void add(DiffElement elt) {
        if (this.getElementMap().containsKey(elt.getName())) {
            throw new IllegalArgumentException("Attempting to rebind already existing binding: " + elt + " node=" + this);
        }
        this.getElementMap().put(elt.getName(), elt);
    }

    @Requires(value={"elt != null"})
    public void add(DiffValue elt) {
        this.add(elt.getBinding());
    }

    @Requires(value={"elts != null"})
    public void add(Collection<DiffElement> elts) {
        for (DiffElement e : elts) {
            this.add(e);
        }
    }

    public void add(String name, Object value) {
        this.add(new DiffElement(name, this.getBinding(), new DiffValue(value)));
    }

    @Override
    public int size() {
        int count = 0;
        for (DiffElement value : this.getElements()) {
            count += value.size();
        }
        return count;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int offset) {
        String off = offset > 0 ? Utils.dupString((char)' ', (int)offset) : "";
        StringBuilder b = new StringBuilder();
        b.append("(").append("\n");
        Collection<DiffElement> atomicElts = this.getAtomicElements();
        for (DiffElement elt : atomicElts) {
            b.append(elt.toString(offset + 2)).append('\n');
        }
        for (DiffElement elt : this.getCompoundElements()) {
            b.append(elt.toString(offset + 4)).append('\n');
        }
        b.append(off).append(")").append("\n");
        return b.toString();
    }

    @Override
    public String toOneLineString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        ArrayList<String> parts = new ArrayList<String>();
        for (DiffElement elt : this.getElements()) {
            parts.add(elt.toOneLineString());
        }
        b.append(Utils.join((String)" ", parts));
        b.append(')');
        return b.toString();
    }

    public static DiffElement fromString(String tree) {
        return DiffNode.fromString(tree, DiffElement.ROOT);
    }

    private static DiffElement fromString(String tree, DiffElement parent) {
        String[] parts = tree.split("=", 2);
        if (parts.length != 2) {
            throw new ReviewedStingException("Unexpected tree structure: " + tree + " parts=" + parts);
        }
        String name = parts[0];
        String value = parts[1];
        if (value.length() == 0) {
            throw new ReviewedStingException("Illegal tree structure: " + value + " at " + tree);
        }
        if (value.charAt(0) == '(') {
            String[] subParts;
            if (!value.endsWith(")")) {
                throw new ReviewedStingException("Illegal tree structure.  Missing ): " + value + " at " + tree);
            }
            String subtree = value.substring(1, value.length() - 1);
            DiffNode rec = DiffNode.empty(name, parent);
            for (String subPart : subParts = subtree.split(" ")) {
                rec.add(DiffNode.fromString(subPart, rec.getBinding()));
            }
            return rec.getBinding();
        }
        return new DiffValue(name, parent, (Object)value).getBinding();
    }
}

