/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.Median;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadGroupProperties
extends ReadWalker<Integer, Integer> {
    @Output
    public PrintStream out;
    @Argument(shortName="maxElementsForMedian", doc="Calculate median from the first maxElementsForMedian values observed", required=false)
    public int MAX_VALUES_FOR_MEDIAN = 10000;
    private static final String TABLE_NAME = "ReadGroupProperties";
    private final Map<String, PerReadGroupInfo> readGroupInfo = new HashMap<String, PerReadGroupInfo>();

    @Override
    public void initialize() {
        for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
            this.readGroupInfo.put(rg.getId(), new PerReadGroupInfo());
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, GATKSAMRecord read) {
        return !read.getReadFailsVendorQualityCheckFlag() && !read.getReadUnmappedFlag();
    }

    @Override
    public boolean isDone() {
        for (PerReadGroupInfo info : this.readGroupInfo.values()) {
            if (!info.needsMoreData()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer map(ReferenceContext referenceContext, GATKSAMRecord read, ReadMetaDataTracker readMetaDataTracker) {
        String rgID = read.getReadGroup().getId();
        PerReadGroupInfo info = this.readGroupInfo.get(rgID);
        if (info.needsMoreData()) {
            info.readLength.add((Comparable)Integer.valueOf(read.getReadLength()));
            ++info.nReadsSeen;
            if (read.getReadPairedFlag()) {
                ++info.nReadsPaired;
                if (read.getInferredInsertSize() != 0) {
                    info.insertSize.add((Comparable)Integer.valueOf(Math.abs(read.getInferredInsertSize())));
                }
            }
        }
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer integer, Integer integer1) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        GATKReport report = new GATKReport();
        report.addTable(TABLE_NAME, "Table of read group properties");
        GATKReportTable table = report.getTable(TABLE_NAME);
        DateFormat dateFormatter = DateFormat.getDateInstance(3);
        table.addPrimaryKey("readgroup");
        table.addColumn("sample", "NA");
        table.addColumn("library", "NA");
        table.addColumn("platform", "NA");
        table.addColumn("center", "NA");
        table.addColumn("date", "NA");
        table.addColumn("has.any.reads", "false");
        table.addColumn("is.paired.end", "false");
        table.addColumn("n.reads.analyzed", "NA");
        table.addColumn("simple.read.type", "NA");
        table.addColumn("median.read.length", 0);
        table.addColumn("median.insert.size", 0);
        for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
            String rgID = rg.getId();
            PerReadGroupInfo info = this.readGroupInfo.get(rgID);
            boolean isPaired = (double)info.nReadsPaired / (1.0 * (double)(info.nReadsSeen + 1)) > 0.25;
            boolean hasAnyReads = info.nReadsSeen > 0;
            int readLength = (Integer)info.readLength.getMedian((Comparable)Integer.valueOf(0));
            this.setTableValue(table, rgID, "sample", rg.getSample());
            this.setTableValue(table, rgID, "library", rg.getLibrary());
            this.setTableValue(table, rgID, "platform", rg.getPlatform());
            this.setTableValue(table, rgID, "center", rg.getSequencingCenter());
            try {
                this.setTableValue(table, rgID, "date", rg.getRunDate() != null ? dateFormatter.format(rg.getRunDate()) : "NA");
            }
            catch (NullPointerException e) {
                this.setTableValue(table, rgID, "date", "NA");
            }
            this.setTableValue(table, rgID, "has.any.reads", hasAnyReads);
            this.setTableValue(table, rgID, "is.paired.end", isPaired);
            this.setTableValue(table, rgID, "n.reads.analyzed", info.nReadsSeen);
            this.setTableValue(table, rgID, "simple.read.type", hasAnyReads ? String.format("%dx%d", isPaired ? 2 : 1, readLength) : "NA");
            this.setTableValue(table, rgID, "median.read.length", hasAnyReads ? Integer.valueOf(readLength) : "NA");
            this.setTableValue(table, rgID, "median.insert.size", hasAnyReads && isPaired ? (Serializable)((Object)info.insertSize.getMedian((Comparable)Integer.valueOf(0))) : "NA");
        }
        report.print(this.out);
    }

    private final void setTableValue(GATKReportTable table, String rgID, String key, Object value) {
        table.set(rgID, key, value == null ? "NA" : value);
    }

    private class PerReadGroupInfo {
        public final Median<Integer> readLength;
        public final Median<Integer> insertSize;
        public int nReadsSeen;
        public int nReadsPaired;

        private PerReadGroupInfo() {
            this.readLength = new Median(ReadGroupProperties.this.MAX_VALUES_FOR_MEDIAN);
            this.insertSize = new Median(ReadGroupProperties.this.MAX_VALUES_FOR_MEDIAN);
            this.nReadsSeen = 0;
            this.nReadsPaired = 0;
        }

        public boolean needsMoreData() {
            return !this.readLength.isFull() || !this.insertSize.isFull();
        }
    }
}

