/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;

@By(value=DataSource.REFERENCE)
public class CallableLociWalker
extends LocusWalker<CallableBaseState, Integrator> {
    @Output
    PrintStream out;
    @Output(fullName="summary", shortName="summary", doc="Name of file for output summary", required=true)
    File summaryFile;
    @Argument(fullName="maxLowMAPQ", shortName="mlmq", doc="Maximum value for MAPQ to be considered a problematic mapped read.", required=false)
    byte maxLowMAPQ = 1;
    @Argument(fullName="minMappingQuality", shortName="mmq", doc="Minimum mapping quality of reads to count towards depth.", required=false)
    byte minMappingQuality = (byte)10;
    @Argument(fullName="minBaseQuality", shortName="mbq", doc="Minimum quality of bases to count towards depth.", required=false)
    byte minBaseQuality = (byte)20;
    @Advanced
    @Argument(fullName="minDepth", shortName="minDepth", doc="Minimum QC+ read depth before a locus is considered callable", required=false)
    int minDepth = 4;
    @Argument(fullName="maxDepth", shortName="maxDepth", doc="Maximum read depth before a locus is considered poorly mapped", required=false)
    int maxDepth = -1;
    @Advanced
    @Argument(fullName="minDepthForLowMAPQ", shortName="mdflmq", doc="Minimum read depth before a locus is considered a potential candidate for poorly mapped", required=false)
    int minDepthLowMAPQ = 10;
    @Argument(fullName="maxFractionOfReadsWithLowMAPQ", shortName="frlmq", doc="If the fraction of reads at a base with low mapping quality exceeds this value, the site may be poorly mapped", required=false)
    double maxLowMAPQFraction = 0.1;
    @Advanced
    @Argument(fullName="format", shortName="format", doc="Output format", required=false)
    OutputFormat outputFormat;

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public void initialize() {
        if (this.getSampleDB().getSamples().size() != 1) {
            throw new UserException.BadArgumentValue("-I", "CallableLoci only works for a single sample, but multiple samples were found in the provided BAM files: " + this.getSampleDB().getSamples());
        }
        try {
            PrintStream summaryOut = new PrintStream(this.summaryFile);
            summaryOut.close();
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.summaryFile, (Exception)e);
        }
    }

    @Override
    public CallableBaseState map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        CalledState state;
        if (BaseUtils.isNBase((byte)ref.getBase())) {
            state = CalledState.REF_N;
        } else {
            int rawDepth = 0;
            int QCDepth = 0;
            int lowMAPQDepth = 0;
            for (PileupElement e : context.getBasePileup()) {
                ++rawDepth;
                if (e.getMappingQual() <= this.maxLowMAPQ) {
                    ++lowMAPQDepth;
                }
                if (e.getMappingQual() < this.minMappingQuality || e.getQual() < this.minBaseQuality && !e.isDeletion()) continue;
                ++QCDepth;
            }
            state = rawDepth == 0 ? CalledState.NO_COVERAGE : (rawDepth >= this.minDepthLowMAPQ && MathUtils.ratio((int)lowMAPQDepth, (int)rawDepth) >= this.maxLowMAPQFraction ? CalledState.POOR_MAPPING_QUALITY : (QCDepth < this.minDepth ? CalledState.LOW_COVERAGE : (rawDepth >= this.maxDepth && this.maxDepth != -1 ? CalledState.EXCESSIVE_COVERAGE : CalledState.CALLABLE)));
        }
        return new CallableBaseState(this.getToolkit().getGenomeLocParser(), context.getLocation(), state);
    }

    @Override
    public Integrator reduceInit() {
        return new Integrator();
    }

    @Override
    public Integrator reduce(CallableBaseState state, Integrator integrator) {
        int n = state.getState().ordinal();
        integrator.counts[n] = integrator.counts[n] + 1L;
        if (this.outputFormat == OutputFormat.STATE_PER_BASE) {
            this.out.println(state.toString());
        }
        if (integrator.state == null) {
            integrator.state = state;
        } else if (state.getLocation().getStart() != integrator.state.getLocation().getStop() + 1 || integrator.state.changingState(state.getState())) {
            this.out.println(integrator.state.toString());
            integrator.state = state;
        } else {
            integrator.state.update(state.getLocation());
        }
        return integrator;
    }

    @Override
    public void onTraversalDone(Integrator result) {
        if (result != null) {
            if (this.outputFormat == OutputFormat.BED) {
                this.out.println(result.state.toString());
            }
            try {
                PrintStream summaryOut = new PrintStream(this.summaryFile);
                summaryOut.printf("%30s %s%n", "state", "nBases");
                for (CalledState state : CalledState.values()) {
                    summaryOut.printf("%30s %d%n", new Object[]{state, result.counts[state.ordinal()]});
                }
                summaryOut.close();
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotCreateOutputFile(this.summaryFile, (Exception)e);
            }
        }
    }

    protected static class CallableBaseState
    implements HasGenomeLocation {
        public final GenomeLocParser genomeLocParser;
        public GenomeLoc loc;
        public final CalledState state;

        public CallableBaseState(GenomeLocParser genomeLocParser, GenomeLoc loc, CalledState state) {
            this.genomeLocParser = genomeLocParser;
            this.loc = loc;
            this.state = state;
        }

        public GenomeLoc getLocation() {
            return this.loc;
        }

        public CalledState getState() {
            return this.state;
        }

        public boolean changingState(CalledState newState) {
            return this.state != newState;
        }

        public void update(GenomeLoc newStop) {
            this.loc = this.genomeLocParser.createGenomeLoc(this.loc.getContig(), this.loc.getStart(), newStop.getStop());
        }

        public String toString() {
            return String.format("%s %d %d %s", new Object[]{this.loc.getContig(), this.loc.getStart(), this.loc.getStop(), this.state});
        }
    }

    protected static class Integrator {
        final long[] counts = new long[CalledState.values().length];
        CallableBaseState state = null;

        protected Integrator() {
        }
    }

    public static enum CalledState {
        REF_N,
        CALLABLE,
        NO_COVERAGE,
        LOW_COVERAGE,
        EXCESSIVE_COVERAGE,
        POOR_MAPPING_QUALITY;

    }

    public static enum OutputFormat {
        BED,
        STATE_PER_BASE;

    }
}

