/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Gather;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRGatherer;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.utils.Utils;

public class RecalibrationArgumentCollection {
    @Input(fullName="knownSites", shortName="knownSites", doc="A database of known polymorphic sites to skip over in the recalibration algorithm", required=false)
    public List<RodBinding<Feature>> knownSites = Collections.emptyList();
    @Gather(value=BQSRGatherer.class)
    @Output
    public File RECAL_FILE;
    @Argument(fullName="list", shortName="ls", doc="List the available covariates and exit", required=false)
    public boolean LIST_ONLY = false;
    @Argument(fullName="covariate", shortName="cov", doc="Covariates to be used in the recalibration. Each covariate is given as a separate cov parameter. ReadGroup and ReportedQuality are required covariates and are already added for you.", required=false)
    public String[] COVARIATES = null;
    @Argument(fullName="standard_covs", shortName="standard", doc="Use the standard set of covariates in addition to the ones listed using the -cov argument", required=false)
    public boolean USE_STANDARD_COVARIATES = true;
    @Hidden
    @Argument(fullName="run_without_dbsnp_potentially_ruining_quality", shortName="run_without_dbsnp_potentially_ruining_quality", required=false, doc="If specified, allows the recalibrator to be used without a dbsnp rod. Very unsafe and for expert users only.")
    public boolean RUN_WITHOUT_DBSNP = false;
    @Argument(fullName="solid_recal_mode", shortName="sMode", required=false, doc="How should we recalibrate solid bases in which the reference was inserted? Options = DO_NOTHING, SET_Q_ZERO, SET_Q_ZERO_BASE_N, or REMOVE_REF_BIAS")
    public RecalDataManager.SOLID_RECAL_MODE SOLID_RECAL_MODE = RecalDataManager.SOLID_RECAL_MODE.SET_Q_ZERO;
    @Argument(fullName="solid_nocall_strategy", shortName="solid_nocall_strategy", doc="Defines the behavior of the recalibrator when it encounters no calls in the color space. Options = THROW_EXCEPTION, LEAVE_READ_UNRECALIBRATED, or PURGE_READ", required=false)
    public RecalDataManager.SOLID_NOCALL_STRATEGY SOLID_NOCALL_STRATEGY = RecalDataManager.SOLID_NOCALL_STRATEGY.THROW_EXCEPTION;
    @Argument(fullName="mismatches_context_size", shortName="mcs", doc="size of the k-mer context to be used for base mismatches", required=false)
    public int MISMATCHES_CONTEXT_SIZE = 2;
    @Argument(fullName="insertions_context_size", shortName="ics", doc="size of the k-mer context to be used for base insertions", required=false)
    public int INSERTIONS_CONTEXT_SIZE = 8;
    @Argument(fullName="deletions_context_size", shortName="dcs", doc="size of the k-mer context to be used for base deletions", required=false)
    public int DELETIONS_CONTEXT_SIZE = 8;
    @Argument(fullName="mismatches_default_quality", shortName="mdq", doc="default quality for the base mismatches covariate", required=false)
    public byte MISMATCHES_DEFAULT_QUALITY = (byte)-1;
    @Argument(fullName="insertions_default_quality", shortName="idq", doc="default quality for the base insertions covariate", required=false)
    public byte INSERTIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="deletions_default_quality", shortName="ddq", doc="default quality for the base deletions covariate", required=false)
    public byte DELETIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="low_quality_tail", shortName="lqt", doc="minimum quality for the bases in the tail of the reads to be considered", required=false)
    public byte LOW_QUAL_TAIL = (byte)2;
    @Argument(fullName="quantizing_levels", shortName="ql", required=false, doc="number of distinct quality scores in the quantized output")
    public int QUANTIZING_LEVELS = 16;
    @Hidden
    @Argument(fullName="default_platform", shortName="dP", required=false, doc="If a read has no platform then default to the provided String. Valid options are illumina, 454, and solid.")
    public String DEFAULT_PLATFORM = null;
    @Hidden
    @Argument(fullName="force_platform", shortName="fP", required=false, doc="If provided, the platform of EVERY read will be forced to be the provided String. Valid options are illumina, 454, and solid.")
    public String FORCE_PLATFORM = null;
    @Hidden
    @Argument(fullName="keep_intermediate_files", shortName="k", required=false, doc="does not remove the temporary csv file created to generate the plots")
    public boolean KEEP_INTERMEDIATE_FILES = false;
    @Hidden
    @Argument(fullName="no_plots", shortName="np", required=false, doc="does not generate any plots -- useful for queue scatter/gathering")
    public boolean NO_PLOTS = false;
    public File recalibrationReport = null;

    public GATKReportTable generateReportTable() {
        GATKReportTable argumentsTable = new GATKReportTable("Arguments", "Recalibration argument collection values used in this run");
        argumentsTable.addPrimaryKey("Argument");
        argumentsTable.addColumn("Value", "null");
        argumentsTable.set("covariate", "Value", this.COVARIATES == null ? "null" : Utils.join((String)",", (String[])this.COVARIATES));
        argumentsTable.set("standard_covs", "Value", this.USE_STANDARD_COVARIATES);
        argumentsTable.set("run_without_dbsnp", "Value", this.RUN_WITHOUT_DBSNP);
        argumentsTable.set("solid_recal_mode", "Value", (Object)this.SOLID_RECAL_MODE);
        argumentsTable.set("solid_nocall_strategy", "Value", (Object)this.SOLID_NOCALL_STRATEGY);
        argumentsTable.set("mismatches_context_size", "Value", this.MISMATCHES_CONTEXT_SIZE);
        argumentsTable.set("insertions_context_size", "Value", this.INSERTIONS_CONTEXT_SIZE);
        argumentsTable.set("deletions_context_size", "Value", this.DELETIONS_CONTEXT_SIZE);
        argumentsTable.set("mismatches_default_quality", "Value", this.MISMATCHES_DEFAULT_QUALITY);
        argumentsTable.set("insertions_default_quality", "Value", this.INSERTIONS_DEFAULT_QUALITY);
        argumentsTable.set("low_quality_tail", "Value", this.LOW_QUAL_TAIL);
        argumentsTable.set("default_platform", "Value", this.DEFAULT_PLATFORM);
        argumentsTable.set("force_platform", "Value", this.FORCE_PLATFORM);
        argumentsTable.set("quantizing_levels", "Value", this.QUANTIZING_LEVELS);
        argumentsTable.set("keep_intermediate_files", "Value", this.KEEP_INTERMEDIATE_FILES);
        argumentsTable.set("no_plots", "Value", this.NO_PLOTS);
        argumentsTable.set("recalibration_report", "Value", this.recalibrationReport == null ? "null" : this.recalibrationReport.getAbsolutePath());
        return argumentsTable;
    }
}

