/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotator;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.RodRequiringAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class TransmissionDisequilibriumTest
extends InfoFieldAnnotation
implements ExperimentalAnnotation,
RodRequiringAnnotation {
    private Set<Sample> trios = null;
    private static final int MIN_NUM_VALID_TRIOS = 5;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (this.trios == null) {
            if (walker instanceof VariantAnnotator) {
                this.trios = ((VariantAnnotator)walker).getSampleDB().getChildrenWithParents();
            } else {
                throw new UserException("Transmission disequilibrium test annotation can only be used from the Variant Annotator and requires a valid ped file be passed in.");
            }
        }
        HashMap<String, Object> toRet = new HashMap<String, Object>(1);
        HashSet<Sample> triosToTest = new HashSet<Sample>();
        for (Sample child : this.trios) {
            boolean hasAppropriateGenotypes = vc.hasGenotype(child.getID()) && vc.getGenotype(child.getID()).hasLikelihoods() && vc.hasGenotype(child.getPaternalID()) && vc.getGenotype(child.getPaternalID()).hasLikelihoods() && vc.hasGenotype(child.getMaternalID()) && vc.getGenotype(child.getMaternalID()).hasLikelihoods();
            if (!hasAppropriateGenotypes) continue;
            triosToTest.add(child);
        }
        if (triosToTest.size() >= 5) {
            toRet.put("TDT", this.calculateTDT(vc, triosToTest));
        }
        return toRet;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("TDT");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("TDT", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Test statistic from Wittkowski transmission disequilibrium test."));
    }

    private List<Double> calculateTDT(VariantContext vc, Set<Sample> triosToTest) {
        ArrayList<Double> pairwiseTDTs = new ArrayList<Double>(10);
        boolean HomRefIndex = false;
        int numAltAlleles = vc.getAlternateAlleles().size();
        for (int alt = 1; alt <= numAltAlleles; ++alt) {
            int HetIndex = alt;
            int HomVarIndex = TransmissionDisequilibriumTest.determineHomIndex(alt, numAltAlleles + 1);
            double nABGivenABandBB = this.calculateNChildren(vc, triosToTest, HetIndex, HetIndex, HomVarIndex) + this.calculateNChildren(vc, triosToTest, HetIndex, HomVarIndex, HetIndex);
            double nBBGivenABandBB = this.calculateNChildren(vc, triosToTest, HomVarIndex, HetIndex, HomVarIndex) + this.calculateNChildren(vc, triosToTest, HomVarIndex, HomVarIndex, HetIndex);
            double nAAGivenABandAB = this.calculateNChildren(vc, triosToTest, 0, HetIndex, HetIndex);
            double nBBGivenABandAB = this.calculateNChildren(vc, triosToTest, HomVarIndex, HetIndex, HetIndex);
            double nAAGivenAAandAB = this.calculateNChildren(vc, triosToTest, 0, 0, HetIndex) + this.calculateNChildren(vc, triosToTest, 0, HetIndex, 0);
            double nABGivenAAandAB = this.calculateNChildren(vc, triosToTest, HetIndex, 0, HetIndex) + this.calculateNChildren(vc, triosToTest, HetIndex, HetIndex, 0);
            double numer = nABGivenABandBB - nBBGivenABandBB + 2.0 * (nAAGivenABandAB - nBBGivenABandAB) + (nAAGivenAAandAB - nABGivenAAandAB);
            double denom = nABGivenABandBB + nBBGivenABandBB + 4.0 * (nAAGivenABandAB + nBBGivenABandAB) + (nAAGivenAAandAB + nABGivenAAandAB);
            pairwiseTDTs.add(numer * numer / denom);
        }
        return pairwiseTDTs;
    }

    private double calculateNChildren(VariantContext vc, Set<Sample> triosToTest, int childIdx, int momIdx, int dadIdx) {
        double[] likelihoodVector = new double[triosToTest.size()];
        int iii = 0;
        for (Sample child : triosToTest) {
            double[] momGL = vc.getGenotype(child.getMaternalID()).getLikelihoods().getAsVector();
            double[] dadGL = vc.getGenotype(child.getPaternalID()).getLikelihoods().getAsVector();
            double[] childGL = vc.getGenotype(child.getID()).getLikelihoods().getAsVector();
            likelihoodVector[iii++] = momGL[momIdx] + dadGL[dadIdx] + childGL[childIdx];
        }
        return MathUtils.sumLog10((double[])likelihoodVector);
    }

    private static int determineHomIndex(int alleleIndex, int numAlleles) {
        int result = 0;
        for (int i = 0; i < alleleIndex; ++i) {
            result += numAlleles--;
        }
        return result;
    }
}

