/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.utils;

import org.broad.tribble.Feature;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;

public abstract class GATKFeature
implements Feature,
HasGenomeLocation {
    String name;

    public GATKFeature(String name) {
        this.name = name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract GenomeLoc getLocation();

    public abstract Object getUnderlyingObject();

    public static class TribbleGATKFeature
    extends GATKFeature {
        private final GenomeLocParser genomeLocParser;
        private final Feature feature;
        private GenomeLoc position = null;

        public TribbleGATKFeature(GenomeLocParser genomeLocParser, Feature f, String name) {
            super(name);
            this.genomeLocParser = genomeLocParser;
            this.feature = f;
        }

        @Override
        public GenomeLoc getLocation() {
            if (this.position == null) {
                this.position = this.genomeLocParser.createGenomeLoc(this.feature.getChr(), this.feature.getStart(), this.feature.getEnd());
            }
            return this.position;
        }

        public String getChr() {
            return this.feature.getChr();
        }

        public int getStart() {
            return this.feature.getStart();
        }

        public int getEnd() {
            return this.feature.getEnd();
        }

        @Override
        public Object getUnderlyingObject() {
            return this.feature;
        }
    }
}

