/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class GenomeLocusIterator
implements Iterator<GenomeLoc> {
    private GenomeLocParser parser;
    private GenomeLoc completeLocus;
    private GenomeLoc currentLocus;

    public GenomeLocusIterator(GenomeLocParser parser, GenomeLoc completeLocus) {
        this.parser = parser;
        this.completeLocus = completeLocus;
        this.currentLocus = parser.createGenomeLoc(completeLocus.getContig(), completeLocus.getStart());
    }

    @Override
    public boolean hasNext() {
        return !this.currentLocus.isPast(this.completeLocus);
    }

    @Override
    public GenomeLoc next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No elements remaining in bounded reference region.");
        }
        GenomeLoc toReturn = this.currentLocus;
        this.currentLocus = this.parser.incPos(this.currentLocus);
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ReferenceLocusIterator is read-only");
    }
}

