/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.LinkedList;
import java.util.List;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import org.broadinstitute.sting.gatk.datasources.reads.BlockInputStream;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;

class BAMAccessPlan {
    private final SAMReaderID reader;
    private final BlockInputStream inputStream;
    private final List<GATKChunk> positions;
    private PeekableIterator<GATKChunk> positionIterator;
    private long nextBlockAddress;

    BAMAccessPlan(SAMReaderID reader, BlockInputStream inputStream, GATKBAMFileSpan fileSpan) {
        this.reader = reader;
        this.inputStream = inputStream;
        this.positions = fileSpan.getGATKChunks();
        this.initialize();
    }

    public SAMReaderID getReader() {
        return this.reader;
    }

    public BlockInputStream getInputStream() {
        return this.inputStream;
    }

    public long getBlockAddress() {
        return this.nextBlockAddress;
    }

    public int getFirstOffsetInBlock() {
        return this.nextBlockAddress == ((GATKChunk)this.positionIterator.peek()).getBlockStart() ? ((GATKChunk)this.positionIterator.peek()).getBlockOffsetStart() : 0;
    }

    public List<GATKChunk> getSpansOverlappingBlock(long blockAddress, long filePosition) {
        LinkedList<GATKChunk> spansOverlapping = new LinkedList<GATKChunk>();
        while (this.positionIterator.hasNext() && ((GATKChunk)this.positionIterator.peek()).getBlockStart() <= blockAddress) {
            int blockOffsetEnd;
            long blockEnd;
            int blockOffsetStart;
            int n = blockOffsetStart = blockAddress == ((GATKChunk)this.positionIterator.peek()).getBlockStart() ? ((GATKChunk)this.positionIterator.peek()).getBlockOffsetStart() : 0;
            if (blockAddress < ((GATKChunk)this.positionIterator.peek()).getBlockEnd()) {
                blockEnd = filePosition;
                blockOffsetEnd = 0;
            } else {
                blockEnd = ((GATKChunk)this.positionIterator.peek()).getBlockEnd();
                blockOffsetEnd = ((GATKChunk)this.positionIterator.peek()).getBlockOffsetEnd();
            }
            GATKChunk newChunk = new GATKChunk(blockAddress, blockOffsetStart, blockEnd, blockOffsetEnd);
            if (newChunk.getChunkStart() <= newChunk.getChunkEnd()) {
                spansOverlapping.add(new GATKChunk(blockAddress, blockOffsetStart, blockEnd, blockOffsetEnd));
            }
            if (!this.positionIterator.hasNext() || ((GATKChunk)this.positionIterator.peek()).getBlockEnd() > blockAddress) break;
            if (((GATKChunk)this.positionIterator.peek()).getBlockEnd() > blockAddress) continue;
            this.positionIterator.next();
        }
        return spansOverlapping;
    }

    public void reset() {
        this.initialize();
    }

    private void initialize() {
        this.positionIterator = new PeekableIterator(this.positions.iterator());
        this.nextBlockAddress = this.positionIterator.hasNext() ? ((GATKChunk)this.positionIterator.peek()).getBlockStart() : -1L;
    }

    void advancePosition(long filePosition) {
        this.nextBlockAddress = BlockCompressedFilePointerUtil.getBlockAddress((long)filePosition);
        while (this.positionIterator.hasNext() && this.isFilePositionPastEndOfChunk(filePosition, (GATKChunk)this.positionIterator.peek())) {
            this.positionIterator.next();
        }
        if (this.positionIterator.hasNext() && filePosition < ((GATKChunk)this.positionIterator.peek()).getChunkStart()) {
            this.nextBlockAddress = ((GATKChunk)this.positionIterator.peek()).getBlockStart();
        }
        if (!this.positionIterator.hasNext()) {
            this.nextBlockAddress = -1L;
        }
    }

    private boolean isFilePositionPastEndOfChunk(long filePosition, GATKChunk chunk) {
        return filePosition >= chunk.getChunkEnd();
    }
}

