/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.Counts;
import org.broadinstitute.sting.alignment.reference.bwt.SequenceBlock;
import org.broadinstitute.sting.alignment.reference.packing.BasePackedInputStream;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.alignment.reference.packing.UnsignedIntPackedInputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWTReader {
    private FileInputStream inputStream;

    public BWTReader(File inputFile) {
        try {
            this.inputStream = new FileInputStream(inputFile);
        }
        catch (FileNotFoundException ex) {
            throw new ReviewedStingException("Unable to open input file", (Throwable)ex);
        }
    }

    public BWT read() {
        SequenceBlock[] sequenceBlocks;
        long[] count;
        long inverseSA0;
        UnsignedIntPackedInputStream uintPackedInputStream = new UnsignedIntPackedInputStream(this.inputStream, ByteOrder.LITTLE_ENDIAN);
        BasePackedInputStream<Integer> basePackedInputStream = new BasePackedInputStream<Integer>(Integer.class, this.inputStream, ByteOrder.LITTLE_ENDIAN);
        try {
            inverseSA0 = uintPackedInputStream.read();
            count = new long[4];
            uintPackedInputStream.read(count);
            long bwtSize = count[3];
            sequenceBlocks = new SequenceBlock[PackUtils.numberOfPartitions(bwtSize, 128L)];
            for (int block = 0; block < sequenceBlocks.length; ++block) {
                int sequenceStart = block * 128;
                int sequenceLength = (int)Math.min(128L, bwtSize - (long)sequenceStart);
                long[] occurrences = new long[4];
                byte[] bwt = new byte[sequenceLength];
                uintPackedInputStream.read(occurrences);
                basePackedInputStream.read(bwt);
                sequenceBlocks[block] = new SequenceBlock(sequenceStart, sequenceLength, new Counts(occurrences, false), bwt);
            }
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to read BWT from input stream.", (Throwable)ex);
        }
        return new BWT(inverseSA0, new Counts(count, true), sequenceBlocks);
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to close input file", (Throwable)ex);
        }
    }
}

