/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAAligner;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.java.AlignmentState;
import org.broadinstitute.sting.alignment.bwa.java.BWAAlignment;
import org.broadinstitute.sting.alignment.bwa.java.LowerBound;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.BWTReader;
import org.broadinstitute.sting.alignment.reference.bwt.Bases;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArrayReader;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;

public class BWAJavaAligner
extends BWAAligner {
    private BWT forwardBWT;
    private BWT reverseBWT;
    private SuffixArray forwardSuffixArray;
    private SuffixArray reverseSuffixArray;
    private final int MAXIMUM_EDIT_DISTANCE = 4;
    private final int MAXIMUM_GAP_OPENS = 1;
    private final int MAXIMUM_GAP_EXTENSIONS = 6;
    public final int MISMATCH_PENALTY = 3;
    public final int GAP_OPEN_PENALTY = 11;
    public final int GAP_EXTENSION_PENALTY = 4;
    public final int INDEL_END_SKIP = 5;

    public BWAJavaAligner(File forwardBWTFile, File reverseBWTFile, File forwardSuffixArrayFile, File reverseSuffixArrayFile) {
        super(null, null);
        this.forwardBWT = new BWTReader(forwardBWTFile).read();
        this.reverseBWT = new BWTReader(reverseBWTFile).read();
        this.forwardSuffixArray = new SuffixArrayReader(forwardSuffixArrayFile, this.forwardBWT).read();
        this.reverseSuffixArray = new SuffixArrayReader(reverseSuffixArrayFile, this.reverseBWT).read();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("BWA aligner can't currently be closed.");
    }

    @Override
    public void updateConfiguration(BWAConfiguration configuration) {
        throw new UnsupportedOperationException("Configuration of the BWA aligner can't currently be changed.");
    }

    @Override
    public Alignment getBestAlignment(byte[] bases) {
        throw new UnsupportedOperationException("BWAJavaAligner does not yet support the standard Aligner interface.");
    }

    @Override
    public SAMRecord align(SAMRecord read, SAMFileHeader header) {
        throw new UnsupportedOperationException("BWAJavaAligner does not yet support the standard Aligner interface.");
    }

    @Override
    public Iterable<Alignment[]> getAllAlignments(byte[] bases) {
        throw new UnsupportedOperationException("BWAJavaAligner does not yet support the standard Aligner interface.");
    }

    @Override
    public Iterable<SAMRecord[]> alignAll(SAMRecord read, SAMFileHeader newHeader) {
        throw new UnsupportedOperationException("BWAJavaAligner does not yet support the standard Aligner interface.");
    }

    public List<Alignment> align(SAMRecord read) {
        BWAAlignment alignment;
        ArrayList<Alignment> successfulMatches = new ArrayList<Alignment>();
        Byte[] uncomplementedBases = this.normalizeBases(read.getReadBases());
        Byte[] complementedBases = this.normalizeBases(Utils.reverse((byte[])BaseUtils.simpleReverseComplement((byte[])read.getReadBases())));
        List<LowerBound> forwardLowerBounds = LowerBound.create(uncomplementedBases, this.forwardBWT);
        List<LowerBound> reverseLowerBounds = LowerBound.create(complementedBases, this.reverseBWT);
        int bestScore = 0x7FFFFFFC;
        int bestDiff = 5;
        int maxDiff = 4;
        PriorityQueue<BWAAlignment> alignments = new PriorityQueue<BWAAlignment>();
        alignments.add(this.createSeedAlignment(this.reverseBWT));
        alignments.add(this.createSeedAlignment(this.forwardBWT));
        while (!alignments.isEmpty() && (alignment = (BWAAlignment)alignments.remove()).getScore() <= bestScore + 3) {
            boolean allowMismatches;
            Byte[] bases = alignment.isNegativeStrand() ? complementedBases : uncomplementedBases;
            BWT bwt = alignment.isNegativeStrand() ? this.forwardBWT : this.reverseBWT;
            List<LowerBound> lowerBounds = alignment.isNegativeStrand() ? reverseLowerBounds : forwardLowerBounds;
            int mismatches = maxDiff - alignment.getMismatches() - alignment.getGapOpens() - alignment.getGapExtensions();
            if (alignment.position < lowerBounds.size() - 1 && mismatches < lowerBounds.get((int)(alignment.position + 1)).value) continue;
            if (mismatches == 0) {
                this.exactMatch(alignment, bases, bwt);
                if (alignment.loBound > alignment.hiBound) continue;
            }
            if (alignment.position >= read.getReadLength() - 1) {
                for (long bwtIndex = alignment.loBound; bwtIndex <= alignment.hiBound; ++bwtIndex) {
                    BWAAlignment finalAlignment = alignment.clone();
                    if (finalAlignment.isNegativeStrand()) {
                        finalAlignment.setAlignmentStart(this.forwardSuffixArray.get(bwtIndex) + 1L);
                    } else {
                        int sizeAlongReference = read.getReadLength() - finalAlignment.getNumberOfBasesMatchingState(AlignmentState.INSERTION) + finalAlignment.getNumberOfBasesMatchingState(AlignmentState.DELETION);
                        finalAlignment.setAlignmentStart(this.reverseBWT.length() - this.reverseSuffixArray.get(bwtIndex) - (long)sizeAlongReference + 1L);
                    }
                    successfulMatches.add(finalAlignment);
                    bestScore = Math.min(finalAlignment.getScore(), bestScore);
                    bestDiff = Math.min(finalAlignment.getMismatches() + finalAlignment.getGapOpens() + finalAlignment.getGapExtensions(), bestDiff);
                    maxDiff = bestDiff + 1;
                }
                continue;
            }
            boolean allowDifferences = mismatches > 0;
            boolean bl = allowMismatches = mismatches > 0;
            if (allowDifferences && alignment.position + 1 >= 4 + alignment.getGapOpens() + alignment.getGapExtensions() && read.getReadLength() - 1 - (alignment.position + 1) >= 5 + alignment.getGapOpens() + alignment.getGapExtensions()) {
                BWAAlignment insertionAlignment;
                if (alignment.getCurrentState() == AlignmentState.MATCH_MISMATCH) {
                    if (alignment.getGapOpens() < 1) {
                        insertionAlignment = this.createInsertionAlignment(alignment);
                        insertionAlignment.incrementGapOpens();
                        alignments.add(insertionAlignment);
                        List<BWAAlignment> deletionAlignments = this.createDeletionAlignments(bwt, alignment);
                        for (BWAAlignment deletionAlignment : deletionAlignments) {
                            deletionAlignment.incrementGapOpens();
                        }
                        alignments.addAll(deletionAlignments);
                    }
                } else if (alignment.getCurrentState() == AlignmentState.INSERTION) {
                    if (alignment.getGapExtensions() < 6 && mismatches > 0) {
                        insertionAlignment = this.createInsertionAlignment(alignment);
                        insertionAlignment.incrementGapExtensions();
                        alignments.add(insertionAlignment);
                    }
                } else if (alignment.getCurrentState() == AlignmentState.DELETION && alignment.getGapExtensions() < 6 && mismatches > 0) {
                    List<BWAAlignment> deletionAlignments = this.createDeletionAlignments(bwt, alignment);
                    for (BWAAlignment deletionAlignment : deletionAlignments) {
                        deletionAlignment.incrementGapExtensions();
                    }
                    alignments.addAll(deletionAlignments);
                }
            }
            alignments.addAll(this.createMatchedAlignments(bwt, alignment, bases, allowDifferences && allowMismatches));
        }
        return successfulMatches;
    }

    private BWAAlignment createSeedAlignment(BWT bwt) {
        BWAAlignment seed = new BWAAlignment(this);
        seed.setNegativeStrand(bwt == this.forwardBWT);
        seed.position = -1;
        seed.loBound = 0L;
        seed.hiBound = bwt.length();
        return seed;
    }

    private List<BWAAlignment> createMatchedAlignments(BWT bwt, BWAAlignment alignment, Byte[] bases, boolean allowMismatch) {
        ArrayList<BWAAlignment> newAlignments = new ArrayList<BWAAlignment>();
        ArrayList<Byte> baseChoices = new ArrayList<Byte>();
        Byte thisBase = bases[alignment.position + 1];
        if (allowMismatch) {
            baseChoices.addAll(Bases.allOf());
        } else {
            baseChoices.add(thisBase);
        }
        if (thisBase != null) {
            do {
                baseChoices.add((Byte)baseChoices.remove(0));
            } while (!thisBase.equals(baseChoices.get(baseChoices.size() - 1)));
        }
        Iterator i$ = baseChoices.iterator();
        while (i$.hasNext()) {
            byte base = (Byte)i$.next();
            BWAAlignment newAlignment = alignment.clone();
            newAlignment.loBound = bwt.counts(base) + bwt.occurrences(base, alignment.loBound - 1L) + 1L;
            newAlignment.hiBound = bwt.counts(base) + bwt.occurrences(base, alignment.hiBound);
            if (newAlignment.loBound > newAlignment.hiBound) continue;
            ++newAlignment.position;
            newAlignment.addState(AlignmentState.MATCH_MISMATCH);
            if (bases[newAlignment.position] == null || base != bases[newAlignment.position]) {
                newAlignment.incrementMismatches();
            }
            newAlignments.add(newAlignment);
        }
        return newAlignments;
    }

    private BWAAlignment createInsertionAlignment(BWAAlignment alignment) {
        BWAAlignment newAlignment = alignment.clone();
        ++newAlignment.position;
        newAlignment.addState(AlignmentState.INSERTION);
        return newAlignment;
    }

    private List<BWAAlignment> createDeletionAlignments(BWT bwt, BWAAlignment alignment) {
        ArrayList<BWAAlignment> newAlignments = new ArrayList<BWAAlignment>();
        for (byte base : Bases.instance) {
            BWAAlignment newAlignment = alignment.clone();
            newAlignment.loBound = bwt.counts(base) + bwt.occurrences(base, alignment.loBound - 1L) + 1L;
            newAlignment.hiBound = bwt.counts(base) + bwt.occurrences(base, alignment.hiBound);
            if (newAlignment.loBound > newAlignment.hiBound) continue;
            newAlignment.addState(AlignmentState.DELETION);
            newAlignments.add(newAlignment);
        }
        return newAlignments;
    }

    private void exactMatch(BWAAlignment alignment, Byte[] bases, BWT bwt) {
        while (++alignment.position < bases.length) {
            byte base = bases[alignment.position];
            alignment.loBound = bwt.counts(base) + bwt.occurrences(base, alignment.loBound - 1L) + 1L;
            alignment.hiBound = bwt.counts(base) + bwt.occurrences(base, alignment.hiBound);
            if (alignment.loBound <= alignment.hiBound) continue;
            return;
        }
    }

    private Byte[] normalizeBases(byte[] bases) {
        Byte[] normalBases = new Byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            normalBases[i] = Bases.fromASCII(bases[i]);
        }
        return normalBases;
    }
}

