/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import java.text.DecimalFormat;

public class StopWatch {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    static final long NANOS_IN_ONE_MICROSECOND = 1000L;
    static final long NANOS_IN_ONE_MILLISECOND = 1000000L;
    static final long NANOS_IN_ONE_SECOND = 1000000000L;
    final String name;
    final long startTime;
    long stopTime;
    Status status;

    public StopWatch(String name) {
        this.name = name;
        this.startTime = System.nanoTime();
        this.status = Status.STARTED;
    }

    public StopWatch stop() {
        return this.stop(System.nanoTime());
    }

    public StopWatch stop(long stopTime) {
        this.status = Status.STOPPED;
        this.stopTime = stopTime;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StopWatch [");
        buf.append(this.name);
        buf.append("] ");
        switch (this.status) {
            case STARTED: {
                buf.append("STARTED");
                break;
            }
            case STOPPED: {
                buf.append("STOPPED at ");
                switch (this.selectDurationUnitForDisplay(this.getResultInNanos())) {
                    case NANOSECOND: {
                        buf.append(this.getResultInNanos());
                        buf.append(" nanoseconds.");
                        break;
                    }
                    case MICROSECOND: {
                        buf.append(this.getResultInMicros());
                        buf.append(" microseconds.");
                        break;
                    }
                    case MILLISSECOND: {
                        buf.append(this.getResultInMillis());
                        buf.append(" milliseconds.");
                        break;
                    }
                    case SECOND: {
                        double seconds = this.getResultInSeconds();
                        buf.append(DECIMAL_FORMAT.format(seconds));
                        buf.append(" seconds.");
                    }
                }
                break;
            }
            default: {
                new IllegalStateException("Status " + (Object)((Object)this.status) + " is not expected");
            }
        }
        return buf.toString();
    }

    DurationUnit selectDurationUnitForDisplay(long durationInNanos) {
        if (durationInNanos < 10000L) {
            return DurationUnit.NANOSECOND;
        }
        if (durationInNanos < 10000000L) {
            return DurationUnit.MICROSECOND;
        }
        if (durationInNanos < 5000000000L) {
            return DurationUnit.MILLISSECOND;
        }
        return DurationUnit.SECOND;
    }

    public final long getResultInNanos() {
        if (this.status == Status.STARTED) {
            return 0L;
        }
        return this.stopTime - this.startTime;
    }

    public final long getResultInMicros() {
        return this.getResultInNanos() / 1000L;
    }

    public final long getResultInMillis() {
        return this.getResultInNanos() / 1000000L;
    }

    public final double getResultInSeconds() {
        return (double)this.getResultInNanos() / 1.0E9;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DurationUnit {
        NANOSECOND,
        MICROSECOND,
        MILLISSECOND,
        SECOND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        STARTED,
        STOPPED;

    }
}

