/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Alignment {
    protected int contigIndex;
    protected long alignmentStart;
    protected boolean negativeStrand;
    protected int mappingQuality;
    protected char[] cigarOperators;
    protected int[] cigarLengths;
    protected int editDistance;
    protected String mismatchingPositions;
    protected int numMismatches;
    protected int numGapOpens;
    protected int numGapExtensions;
    protected int bestCount;
    protected int secondBestCount;

    public int getContigIndex() {
        return this.contigIndex;
    }

    public long getAlignmentStart() {
        return this.alignmentStart;
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public int getMappingQuality() {
        return this.mappingQuality;
    }

    public int getEditDistance() {
        return this.editDistance;
    }

    public String getMismatchingPositions() {
        return this.mismatchingPositions;
    }

    public int getNumMismatches() {
        return this.numMismatches;
    }

    public int getNumGapOpens() {
        return this.numGapOpens;
    }

    public int getNumGapExtensions() {
        return this.numGapExtensions;
    }

    public int getBestCount() {
        return this.bestCount;
    }

    public int getSecondBestCount() {
        return this.secondBestCount;
    }

    public Cigar getCigar() {
        Cigar cigar = new Cigar();
        for (int i = 0; i < this.cigarOperators.length; ++i) {
            CigarOperator operator = CigarOperator.characterToEnum((int)this.cigarOperators[i]);
            cigar.add(new CigarElement(this.cigarLengths[i], operator));
        }
        return cigar;
    }

    public String getCigarString() {
        Cigar cigar = this.getCigar();
        if (cigar.isEmpty()) {
            return "*";
        }
        StringBuilder cigarString = new StringBuilder();
        for (CigarElement element : cigar.getCigarElements()) {
            cigarString.append(element.getLength());
            cigarString.append(element.getOperator());
        }
        return cigarString.toString();
    }

    public Alignment() {
    }

    public Alignment(int contigIndex, int alignmentStart, boolean negativeStrand, int mappingQuality, char[] cigarOperators, int[] cigarLengths, int editDistance, String mismatchingPositions, int numMismatches, int numGapOpens, int numGapExtensions, int bestCount, int secondBestCount) {
        this.contigIndex = contigIndex;
        this.alignmentStart = alignmentStart;
        this.negativeStrand = negativeStrand;
        this.mappingQuality = mappingQuality;
        this.cigarOperators = cigarOperators;
        this.cigarLengths = cigarLengths;
        this.editDistance = editDistance;
        this.mismatchingPositions = mismatchingPositions;
        this.numMismatches = numMismatches;
        this.numGapOpens = numGapOpens;
        this.numGapExtensions = numGapExtensions;
        this.bestCount = bestCount;
        this.secondBestCount = secondBestCount;
    }

    public static SAMRecord convertToRead(Alignment alignment, SAMRecord unmappedRead, SAMFileHeader newSAMHeader) {
        SAMRecord read;
        try {
            read = (SAMRecord)unmappedRead.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ReviewedStingException("Unable to create aligned read from template.");
        }
        if (newSAMHeader != null) {
            read.setHeader(newSAMHeader);
        }
        read.setReferenceName("*");
        read.setAlignmentStart(0);
        read.setMateReferenceName("*");
        read.setMateAlignmentStart(0);
        if (alignment != null) {
            read.setReadUnmappedFlag(false);
            read.setReferenceIndex(alignment.getContigIndex());
            read.setAlignmentStart((int)alignment.getAlignmentStart());
            read.setReadNegativeStrandFlag(alignment.isNegativeStrand());
            read.setMappingQuality(alignment.getMappingQuality());
            read.setCigar(alignment.getCigar());
            if (alignment.isNegativeStrand()) {
                read.setReadBases(BaseUtils.simpleReverseComplement((byte[])read.getReadBases()));
                read.setBaseQualities(Utils.reverse((byte[])read.getBaseQualities()));
            }
            read.setAttribute("NM", (Object)alignment.getEditDistance());
            read.setAttribute("MD", (Object)alignment.getMismatchingPositions());
        }
        return read;
    }
}

