/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.CommonInfo;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;

public class Genotype
implements Comparable<Genotype> {
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    protected CommonInfo commonInfo;
    public static final double NO_LOG10_PERROR = 1.0;
    protected List<Allele> alleles = null;
    protected Type type = null;
    protected boolean isPhased = false;

    public Genotype(String sampleName, List<Allele> alleles, double log10PError, Set<String> filters, Map<String, Object> attributes, boolean isPhased) {
        this(sampleName, alleles, log10PError, filters, attributes, isPhased, null);
    }

    public Genotype(String sampleName, List<Allele> alleles, double log10PError, Set<String> filters, Map<String, Object> attributes, boolean isPhased, double[] log10Likelihoods) {
        this.alleles = alleles == null || alleles.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(alleles);
        this.commonInfo = new CommonInfo(sampleName, log10PError, filters, attributes);
        if (log10Likelihoods != null) {
            this.commonInfo.putAttribute("PL", GenotypeLikelihoods.fromLog10Likelihoods(log10Likelihoods));
        }
        this.isPhased = isPhased;
        this.validate();
    }

    public Genotype(String sampleName, List<Allele> alleles, double log10PError, double[] log10Likelihoods) {
        this(sampleName, alleles, log10PError, null, null, false, log10Likelihoods);
    }

    public Genotype(String sampleName, List<Allele> alleles, double log10PError) {
        this(sampleName, alleles, log10PError, null, null, false);
    }

    public Genotype(String sampleName, List<Allele> alleles) {
        this(sampleName, alleles, 1.0, null, null, false);
    }

    public Genotype(String sampleName, Genotype parent) {
        this(sampleName, parent.getAlleles(), parent.getLog10PError(), parent.getFilters(), parent.getAttributes(), parent.isPhased());
    }

    public static Genotype modifyName(Genotype g, String name) {
        return new Genotype(name, g.getAlleles(), g.getLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, g.getAttributes(), g.isPhased());
    }

    public static Genotype modifyAttributes(Genotype g, Map<String, Object> attributes) {
        return new Genotype(g.getSampleName(), g.getAlleles(), g.getLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, attributes, g.isPhased());
    }

    public static Genotype modifyAlleles(Genotype g, List<Allele> alleles) {
        return new Genotype(g.getSampleName(), alleles, g.getLog10PError(), g.filtersWereApplied() ? g.getFilters() : null, g.getAttributes(), g.isPhased());
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<Allele> getAlleles(Allele allele) {
        ArrayList<Allele> al = new ArrayList<Allele>();
        for (Allele a : this.alleles) {
            if (!a.equals(allele)) continue;
            al.add(a);
        }
        return Collections.unmodifiableList(al);
    }

    public Allele getAllele(int i) {
        if (this.getType() == Type.UNAVAILABLE) {
            throw new ReviewedStingException("Requesting alleles for an UNAVAILABLE genotype");
        }
        return this.alleles.get(i);
    }

    public boolean isPhased() {
        return this.isPhased;
    }

    public int getPloidy() {
        if (this.alleles.size() == 0) {
            throw new ReviewedStingException("Requesting ploidy for an UNAVAILABLE genotype");
        }
        return this.alleles.size();
    }

    public Type getType() {
        if (this.type == null) {
            this.type = this.determineType();
        }
        return this.type;
    }

    protected Type determineType() {
        if (this.alleles.size() == 0) {
            return Type.UNAVAILABLE;
        }
        boolean sawNoCall = false;
        boolean sawMultipleAlleles = false;
        Allele observedAllele = null;
        for (Allele allele : this.alleles) {
            if (allele.isNoCall()) {
                sawNoCall = true;
                continue;
            }
            if (observedAllele == null) {
                observedAllele = allele;
                continue;
            }
            if (allele.equals(observedAllele)) continue;
            sawMultipleAlleles = true;
        }
        if (sawNoCall) {
            if (observedAllele == null) {
                return Type.NO_CALL;
            }
            return Type.MIXED;
        }
        if (observedAllele == null) {
            throw new ReviewedStingException("BUG: there are no alleles present in this genotype but the alleles list is not null");
        }
        return sawMultipleAlleles ? Type.HET : (observedAllele.isReference() ? Type.HOM_REF : Type.HOM_VAR);
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == Type.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == Type.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == Type.HET;
    }

    public boolean isNoCall() {
        return this.getType() == Type.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != Type.NO_CALL && this.getType() != Type.UNAVAILABLE;
    }

    public boolean isMixed() {
        return this.getType() == Type.MIXED;
    }

    public boolean isAvailable() {
        return this.getType() != Type.UNAVAILABLE;
    }

    public boolean hasLikelihoods() {
        return this.hasAttribute("PL") && !this.getAttribute("PL").equals(".") || this.hasAttribute("GL") && !this.getAttribute("GL").equals(".");
    }

    public GenotypeLikelihoods getLikelihoods() {
        GenotypeLikelihoods x = this.getLikelihoods("PL", true);
        if (x != null) {
            return x;
        }
        x = this.getLikelihoods("GL", false);
        if (x != null) {
            return x;
        }
        throw new IllegalStateException("BUG: genotype likelihood field in " + this.getSampleName() + " sample are not either a string or a genotype likelihood class!");
    }

    private GenotypeLikelihoods getLikelihoods(String key, boolean asPL) {
        Object x = this.getAttribute(key);
        if (x instanceof String) {
            if (asPL) {
                return GenotypeLikelihoods.fromPLField((String)x);
            }
            return GenotypeLikelihoods.fromGLField((String)x);
        }
        if (x instanceof GenotypeLikelihoods) {
            return (GenotypeLikelihoods)x;
        }
        return null;
    }

    public void validate() {
        if (this.alleles.size() == 0) {
            return;
        }
        for (Allele allele : this.alleles) {
            if (allele != null) continue;
            throw new IllegalArgumentException("BUG: allele cannot be null in Genotype");
        }
    }

    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    public String getGenotypeString(boolean ignoreRefState) {
        if (this.alleles.size() == 0) {
            return null;
        }
        return ParsingUtils.join((String)(this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR), ignoreRefState ? this.getAlleleStrings() : (this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles())));
    }

    private List<String> getAlleleStrings() {
        ArrayList<String> al = new ArrayList<String>();
        for (Allele a : this.alleles) {
            al.add(a.getBaseString());
        }
        return al;
    }

    public String toString() {
        int Q = (int)Math.round(this.getPhredScaledQual());
        return String.format("[%s %s Q%s %s]", this.getSampleName(), this.getGenotypeString(false), Q == -10 ? "." : String.format("%2d", Q), Genotype.sortedString(this.getAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%.2f", this.getGenotypeString(false), this.getPhredScaledQual());
    }

    public boolean sameGenotype(Genotype other) {
        return this.sameGenotype(other, true);
    }

    public boolean sameGenotype(Genotype other, boolean ignorePhase) {
        if (this.getPloidy() != other.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> thisAlleles = this.getAlleles();
        SequencedCollection<Allele> otherAlleles = other.getAlleles();
        if (ignorePhase) {
            thisAlleles = new TreeSet<Allele>(thisAlleles);
            otherAlleles = new TreeSet<Allele>(otherAlleles);
        }
        return ((Object)thisAlleles).equals(otherAlleles);
    }

    private static <T extends Comparable<T>, V> String sortedString(Map<T, V> c) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k : t) {
            pairs.add(k + "=" + c.get(k));
        }
        return "{" + ParsingUtils.join((String)", ", (String[])pairs.toArray(new String[pairs.size()])) + "}";
    }

    public String getSampleName() {
        return this.commonInfo.getName();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public Set<String> getFiltersMaybeNull() {
        return this.commonInfo.getFiltersMaybeNull();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.commonInfo.filtersWereApplied();
    }

    public boolean hasLog10PError() {
        return this.commonInfo.hasLog10PError();
    }

    public double getLog10PError() {
        return this.commonInfo.getLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    public Object getAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return this.commonInfo.getAttributeAsString(key, defaultValue);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return this.commonInfo.getAttributeAsInt(key, defaultValue);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return this.commonInfo.getAttributeAsDouble(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return this.commonInfo.getAttributeAsBoolean(key, defaultValue);
    }

    @Override
    public int compareTo(Genotype genotype) {
        return this.getSampleName().compareTo(genotype.getSampleName());
    }

    public static enum Type {
        NO_CALL,
        HOM_REF,
        HET,
        HOM_VAR,
        UNAVAILABLE,
        MIXED;

    }
}

