/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFIDHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFUtils {
    private VCFUtils() {
    }

    public static <T extends Feature> Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, List<RodBinding<T>> rodBindings) {
        TreeSet<String> names = new TreeSet<String>();
        for (RodBinding<T> evalRod : rodBindings) {
            names.add(evalRod.getName());
        }
        return VCFUtils.getVCFHeadersFromRods(toolkit, names);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit) {
        return VCFUtils.getVCFHeadersFromRods(toolkit, (Collection<String>)null);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (rodNames != null && !rodNames.contains(source.getName()) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRodPrefix(GenomeAnalysisEngine toolkit, String prefix) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (!source.getName().startsWith(prefix) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit) {
        return VCFUtils.getHeaderFields(toolkit, null);
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        TreeSet<VCFHeaderLine> fields = new TreeSet<VCFHeaderLine>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            VCFHeader header;
            if (rodNames != null && !rodNames.contains(source.getName()) || !source.getRecordType().equals(VariantContext.class) || (header = (VCFHeader)source.getHeader()) == null) continue;
            fields.addAll(header.getMetaData());
        }
        return fields;
    }

    public static Set<VCFHeaderLine> smartMergeHeaders(Collection<VCFHeader> headers, Logger logger) throws IllegalStateException {
        HashMap<String, VCFHeaderLine> map = new HashMap<String, VCFHeaderLine>();
        HeaderConflictWarner conflictWarner = new HeaderConflictWarner(logger);
        for (VCFHeader source : headers) {
            for (VCFHeaderLine line : source.getMetaData()) {
                String key = line.getKey();
                if (line instanceof VCFIDHeaderLine) {
                    key = key + "-" + ((VCFIDHeaderLine)((Object)line)).getID();
                }
                if (map.containsKey(key)) {
                    VCFHeaderLine other = (VCFHeaderLine)map.get(key);
                    if (line.equals(other)) continue;
                    if (!line.getClass().equals(other.getClass())) {
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFFilterHeaderLine) {
                        String otherName;
                        String lineName = ((VCFFilterHeaderLine)line).getID();
                        if (lineName.equals(otherName = ((VCFFilterHeaderLine)other).getID())) continue;
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFCompoundHeaderLine) {
                        VCFCompoundHeaderLine compLine = (VCFCompoundHeaderLine)line;
                        VCFCompoundHeaderLine compOther = (VCFCompoundHeaderLine)other;
                        if (!compLine.equalsExcludingDescription(compOther)) {
                            if (compLine.getType().equals((Object)compOther.getType())) {
                                conflictWarner.warn(line, "Promoting header field Number to . due to number differences in header lines: " + line + " " + other);
                                compOther.setNumberToUnbounded();
                            } else if (compLine.getType() == VCFHeaderLineType.Integer && compOther.getType() == VCFHeaderLineType.Float) {
                                conflictWarner.warn(line, "Promoting Integer to Float in header: " + compOther);
                                map.put(key, compOther);
                            } else if (compLine.getType() == VCFHeaderLineType.Float && compOther.getType() == VCFHeaderLineType.Integer) {
                                conflictWarner.warn(line, "Promoting Integer to Float in header: " + compOther);
                            } else {
                                throw new IllegalStateException("Incompatible header types, collision between these two types: " + line + " " + other);
                            }
                        }
                        if (compLine.getDescription().equals(compOther)) continue;
                        conflictWarner.warn(line, "Allowing unequal description fields through: keeping " + compOther + " excluding " + compLine);
                        continue;
                    }
                    conflictWarner.warn(line, "Ignoring header line already in map: this header line = " + line + " already present header = " + other);
                    continue;
                }
                map.put(key, line);
            }
        }
        return new HashSet<VCFHeaderLine>(map.values());
    }

    public static String rsIDOfFirstRealVariant(List<VariantContext> VCs, VariantContext.Type type) {
        if (VCs == null) {
            return null;
        }
        String rsID = null;
        for (VariantContext vc : VCs) {
            if (vc.getType() != type) continue;
            rsID = vc.getID();
            break;
        }
        return rsID;
    }

    private static final class HeaderConflictWarner {
        Logger logger;
        Set<String> alreadyIssued = new HashSet<String>();

        private HeaderConflictWarner(Logger logger) {
            this.logger = logger;
        }

        public void warn(VCFHeaderLine line, String msg) {
            if (this.logger != null && !this.alreadyIssued.contains(line.getKey())) {
                this.alreadyIssued.add(line.getKey());
                this.logger.warn((Object)msg);
            }
        }
    }
}

