/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CompositeIndex;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaData;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.samtools.util.CloserUtil;

abstract class PerTilePerCycleParser<ILLUMINA_DATA extends IlluminaData>
implements IlluminaParser<ILLUMINA_DATA> {
    private final File laneDirectory;
    private final int lane;
    private final List<CycleFileParser<ILLUMINA_DATA>> cycleFileParsers;
    private final CompositeIndex[] cycleToIndex;
    private final int[] outputLengths;
    private final int totalCycles;
    private int tileNumber = 0;
    protected final CycleIlluminaFileMap tilesToCycleFiles;

    public PerTilePerCycleParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, int[] outputLengths) {
        this.lane = lane;
        this.laneDirectory = new File(directory, "L00" + this.lane);
        this.tilesToCycleFiles = tilesToCycleFiles;
        this.tileNumber = (Integer)tilesToCycleFiles.firstKey();
        this.outputLengths = outputLengths;
        int cycles = 0;
        for (int i = 0; i < outputLengths.length; ++i) {
            cycles += outputLengths[i];
        }
        this.totalCycles = cycles;
        this.cycleFileParsers = new ArrayList<CycleFileParser<ILLUMINA_DATA>>(this.totalCycles);
        this.cycleToIndex = new CompositeIndex[cycles + 1];
        this.cycleToIndex[0] = null;
        int arrIndex = 0;
        int elementIndex = 0;
        for (int i = 0; i < this.totalCycles; ++i) {
            if (elementIndex >= outputLengths[arrIndex]) {
                elementIndex = 0;
                ++arrIndex;
            }
            this.cycleToIndex[i + 1] = new CompositeIndex(arrIndex, elementIndex);
            ++elementIndex;
        }
    }

    protected abstract ILLUMINA_DATA makeData(int[] var1);

    protected abstract CycleFileParser<ILLUMINA_DATA> makeCycleFileParser(File var1, int var2);

    protected CompositeIndex getIndex(int cycle) {
        return this.cycleToIndex[cycle];
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.tileNumber = oneBasedTileNumber;
        CycleFilesIterator filesIterator = (CycleFilesIterator)this.tilesToCycleFiles.get(this.tileNumber);
        CloserUtil.close(this.cycleFileParsers);
        this.cycleFileParsers.clear();
        int cycleIndex = 0;
        while (filesIterator.hasNext()) {
            this.cycleFileParsers.add(this.makeCycleFileParser(filesIterator.next(), ++cycleIndex));
        }
        if (cycleIndex != this.totalCycles) {
            throw new PicardException("Number of cycle files found (" + cycleIndex + ") does not equal the number expected (" + this.totalCycles + ")");
        }
    }

    @Override
    public ILLUMINA_DATA next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("IlluminaData is missing in lane " + this.lane + " at directory location " + this.laneDirectory.getAbsolutePath());
        }
        if (!this.cycleFileParsers.get(0).hasNext()) {
            this.seekToTile(this.tileNumber + 1);
        }
        ILLUMINA_DATA data = this.makeData(this.outputLengths);
        for (int i = 0; i < this.totalCycles; ++i) {
            this.cycleFileParsers.get(i).next(data);
        }
        return data;
    }

    @Override
    public boolean hasNext() {
        if (this.cycleFileParsers.get(0).hasNext()) {
            return true;
        }
        return this.tileNumber < (Integer)this.tilesToCycleFiles.lastKey();
    }

    @Override
    public void verifyData(ReadStructure readStructure, List<Integer> tiles) {
        if (tiles == null) {
            tiles = new ArrayList(this.tilesToCycleFiles.keySet());
        }
        this.tilesToCycleFiles.assertValid(tiles, readStructure.totalCycles);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + this.getClass().getName());
    }

    protected static interface CycleFileParser<ILLUMINA_DATA> {
        public void close();

        public void next(ILLUMINA_DATA var1);

        public boolean hasNext();
    }
}

