/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileNotFoundException;
import net.sf.picard.io.IoUtil;

public class IlluminaFileUtil {
    private static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("C(\\d+)\\..+");
    private static final ThreadLocal<NumberFormat> tileNumberFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMinimumIntegerDigits(4);
            formatter.setGroupingUsed(false);
            return formatter;
        }
    };

    public static boolean endedIlluminaBasecallFilesExist(File directory, String fileType, int lane, int end) {
        return IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, fileType, lane, end).size() > 0;
    }

    public static int getNumberOfIlluminaEnds(File directory, String fileType, int lane) {
        String regexp = "s_" + lane + "_(\\d+)_\\d{4}_" + fileType + ".txt(.gz)?";
        Pattern pattern = Pattern.compile(regexp);
        File[] files = IlluminaFileUtil.getNonEmptyFilesMatchingRegexp(directory, pattern);
        int highestMatch = 0;
        for (int i = 0; i < files.length; ++i) {
            Matcher m = pattern.matcher(files[i].getName());
            m.matches();
            String tileString = m.group(1);
            int end = Integer.parseInt(tileString);
            if (end <= highestMatch) continue;
            highestMatch = end;
        }
        return highestMatch;
    }

    public static IlluminaFileMap getEndedIlluminaBasecallFiles(File directory, String fileType, int lane, int end) {
        String regexp = "s_" + lane + "_" + end + "_(\\d{4})_" + fileType + ".txt(.gz)?";
        return IlluminaFileUtil.getTiledIlluminaBasecallFiles(directory, regexp);
    }

    public static IlluminaFileMap getEndedIlluminaBasecallFiles(File directory, String fileType, int lane, int end, List<Integer> tiles) {
        if (tiles == null) {
            return IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, fileType, lane, end);
        }
        IlluminaFileMap ret = new IlluminaFileMap();
        for (int i = 0; i < tiles.size(); ++i) {
            String filename = "s_" + lane + "_" + end + "_" + tileNumberFormatter.get().format(tiles.get(i)) + "_" + fileType + ".txt";
            File f = new File(directory, filename);
            if (!f.exists() && !(f = new File(directory, filename + ".gz")).exists()) {
                throw new IlluminaFileNotFoundException(f, "Requested tile file " + f + " not found, with or without .gz.");
            }
            ret.put(tiles.get(i), f);
        }
        return ret;
    }

    static IlluminaFileMap getTiledIlluminaBasecallFiles(File directory, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        File[] files = IlluminaFileUtil.getNonEmptyFilesMatchingRegexp(directory, pattern);
        IlluminaFileMap ret = new IlluminaFileMap();
        for (int i = 0; i < files.length; ++i) {
            Matcher m = pattern.matcher(files[i].getName());
            m.matches();
            String tileString = m.group(1);
            int tile = Integer.parseInt(tileString);
            ret.put(tile, files[i]);
        }
        return ret;
    }

    private static File[] getNonEmptyFilesMatchingRegexp(File directory, Pattern pattern) {
        File[] files = IoUtil.getFilesMatchingRegexp(directory, pattern);
        ArrayList<File> nonEmptyFiles = new ArrayList<File>(files.length);
        for (File file : files) {
            if (file.length() <= 0L) continue;
            nonEmptyFiles.add(file);
        }
        return nonEmptyFiles.toArray(new File[nonEmptyFiles.size()]);
    }

    public static boolean nonEndedIlluminaBasecallFilesExist(File directory, String fileType, int lane) {
        return IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane).size() > 0;
    }

    public static IlluminaFileMap getNonEndedIlluminaBasecallFiles(File directory, String fileType, int lane) {
        String regexp = "s_" + lane + "_(\\d{4})_" + fileType + ".txt(.gz)?";
        return IlluminaFileUtil.getTiledIlluminaBasecallFiles(directory, regexp);
    }

    public static IlluminaFileMap getNonEndedIlluminaBasecallFiles(File directory, String fileType, int lane, List<Integer> tiles) {
        if (tiles == null) {
            return IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane);
        }
        IlluminaFileMap ret = new IlluminaFileMap();
        for (int i = 0; i < tiles.size(); ++i) {
            String filename = IlluminaFileUtil.makeNonEndedIlluminaBasecallFilename(fileType, lane, tiles.get(i));
            File f = new File(directory, filename);
            if (!f.exists() && !(f = new File(directory, filename + ".gz")).exists()) {
                throw new IlluminaFileNotFoundException(f, "Requested tile file " + f + " not found, with or without .gz.");
            }
            ret.put(tiles.get(i), f);
        }
        return ret;
    }

    public static CycleIlluminaFileMap getCyledIlluminaFiles(File directory, String fileExt, int lane, List<Integer> tiles, int expectedCycles) {
        File laneDir = new File(directory, "L00" + lane);
        File[] tempCycleDirs = IoUtil.getFilesMatchingRegexp(laneDir, CYCLE_SUBDIRECTORY_PATTERN);
        if (tempCycleDirs == null || tempCycleDirs.length == 0) {
            throw new IlluminaFileNotFoundException(directory, directory + " has no cycle subdirectories");
        }
        CycleDirectoryComparator comparator = new CycleDirectoryComparator();
        Arrays.sort(tempCycleDirs, comparator);
        for (int i = 0; i < tempCycleDirs.length - 1; ++i) {
            if (comparator.compare(tempCycleDirs[i], tempCycleDirs[i + 1]) != 0) continue;
            throw new PicardException("More than one directory with same cycle number: " + tempCycleDirs[i] + "; " + tempCycleDirs[i + 1]);
        }
        CycleIlluminaFileMap cycledMap = new CycleIlluminaFileMap();
        if (tiles == null) {
            String regexp = "s_" + lane + "_(\\d+)." + fileExt;
            IlluminaFileMap tileMap = IlluminaFileUtil.getTiledIlluminaBasecallFiles(tempCycleDirs[0], regexp);
            for (int i = 1; i <= (Integer)tileMap.lastKey(); ++i) {
                cycledMap.put(i, new CycleFilesIterator(laneDir, lane, i, fileExt));
            }
        } else {
            for (int i = 0; i < tiles.size(); ++i) {
                cycledMap.put(i, new CycleFilesIterator(laneDir, lane, i, fileExt));
            }
        }
        return cycledMap;
    }

    public static String makeNonEndedIlluminaBasecallFilename(String fileType, int lane, int tile) {
        return "s_" + lane + "_" + tileNumberFormatter.get().format(tile) + "_" + fileType + ".txt";
    }

    private static class CycleDirectoryComparator
    implements Comparator<File> {
        private CycleDirectoryComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            Matcher matcher = CYCLE_SUBDIRECTORY_PATTERN.matcher(file1.getName());
            if (!matcher.matches()) {
                throw new PicardException("unpossible");
            }
            int cycle1 = Integer.parseInt(matcher.group(1));
            matcher = CYCLE_SUBDIRECTORY_PATTERN.matcher(file2.getName());
            if (!matcher.matches()) {
                throw new PicardException("unpossible");
            }
            int cycle2 = Integer.parseInt(matcher.group(1));
            return cycle1 - cycle2;
        }
    }
}

