/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

class CycleFilesIterator
implements Iterator<File>,
Iterable<File> {
    private final File parentDir;
    private final int lane;
    private final int tile;
    private final String fileExt;
    private File nextFile;
    private int nextCycle;

    public CycleFilesIterator(File laneDir, int lane, int tile, String fileExt) {
        this.parentDir = laneDir;
        this.lane = lane;
        this.tile = tile;
        this.fileExt = fileExt;
        this.nextCycle = 1;
        this.findNextFile();
    }

    CycleFilesIterator(CycleFilesIterator template) {
        this(template.parentDir, template.lane, template.tile, template.fileExt);
    }

    private void findNextFile() {
        File cycleDir = new File(this.parentDir, "C" + this.nextCycle + ".1");
        this.nextFile = new File(cycleDir, "s_" + this.lane + "_" + this.tile + "." + this.fileExt);
    }

    @Override
    public boolean hasNext() {
        return this.nextFile.exists();
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File curFile = this.nextFile;
        ++this.nextCycle;
        this.findNextFile();
        return curFile;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + CycleFilesIterator.class.getName());
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }
}

