/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.filter.AggregateFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.ClippingUtility;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToSamConverter {
    private final String runBarcode;
    private final String readGroupId;
    private final ReadStructure readStructure;
    private AggregateFilter filters;
    private int barcodeIndex;
    private final boolean isPairedEnd;
    private final boolean isBarcoded;
    private static final Log log = Log.getInstance(IlluminaBasecallsToSamConverter.class);

    public IlluminaBasecallsToSamConverter(String runBarcode, String readGroupId, ReadStructure readStructure) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.readStructure = readStructure;
        if (readStructure.numTemplates > 3) {
            throw new PicardException("IlluminaBasecallsToSamConverter does not support more than 2 template reads.  Number of template reads found in configuration: " + readStructure.numTemplates);
        }
        if (readStructure.numBarcodes > 1) {
            throw new PicardException("IlluminaBasecallsToSamConverter does not support more than 1 barcode read.  Number of template reads found in configuration: " + readStructure.numBarcodes);
        }
        this.isPairedEnd = readStructure.numTemplates == 2;
        this.isBarcoded = readStructure.numBarcodes > 0;
        this.barcodeIndex = -1;
        if (readStructure.barcodeIndices.length > 0) {
            this.barcodeIndex = readStructure.barcodeIndices[0];
        }
        this.initializeFilters();
    }

    private void initializeFilters() {
        this.filters = new AggregateFilter(Arrays.asList(new SolexaNoiseFilter()));
    }

    private String createReadName(ClusterData cluster) {
        return IlluminaUtil.makeReadName(this.runBarcode, cluster.getLane(), cluster.getTile(), cluster.getX(), cluster.getY());
    }

    public int getNumRecordsPerCluster() {
        return this.readStructure.numTemplates;
    }

    private SAMRecord createSamRecord(ReadData readData, SAMFileHeader header, String readName, boolean isPf, boolean firstOfPair, ReadData unmatchedBarcodeRead) {
        SAMRecord sam = new SAMRecord(header);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute("RG", (Object)this.readGroupId);
        }
        if (unmatchedBarcodeRead != null) {
            sam.setAttribute("BC", (Object)StringUtil.bytesToString((byte[])unmatchedBarcodeRead.getBases()).replace('.', 'N'));
        }
        return sam;
    }

    public void createSamRecords(ClusterData cluster, SAMFileHeader header, boolean markAdapter, SAMRecord[] recordsOut) {
        SAMRecord firstOfPair;
        String readName = this.createReadName(cluster);
        recordsOut[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.readStructure.templateIndices[0]), header, readName, cluster.isPf(), true, cluster.getMatchedBarcode() == null && this.isBarcoded ? cluster.getRead(this.barcodeIndex) : null);
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            recordsOut[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.readStructure.templateIndices[1]), header, readName, cluster.isPf(), false, cluster.getMatchedBarcode() == null && this.isBarcoded ? cluster.getRead(this.barcodeIndex) : null);
        }
        if (markAdapter) {
            if (this.isPairedEnd) {
                assert (firstOfPair.getFirstOfPairFlag() && secondOfPair.getSecondOfPairFlag());
                String warnString = ClippingUtility.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair, this.isBarcoded ? IlluminaUtil.IlluminaAdapterPair.INDEXED.adapterPair : IlluminaUtil.IlluminaAdapterPair.PAIRED_END.adapterPair);
                if (warnString != null) {
                    log.debug("Adapter trimming " + warnString);
                }
            } else {
                ClippingUtility.adapterTrimIlluminaSingleRead(firstOfPair, this.isBarcoded ? IlluminaUtil.IlluminaAdapterPair.INDEXED.adapterPair : IlluminaUtil.IlluminaAdapterPair.PAIRED_END.adapterPair);
            }
        }
    }
}

