/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.HsMetricsCalculator;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.SequenceUtil;

public class CalculateHsMetrics
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CalculateHsMetrics.class);
    private HsMetricsCalculator baseCalculator = null;
    @Usage
    public final String USAGE = "Calculates a set of Hybrid Selection specific metrics from an aligned SAMor BAM file. If a reference sequence is provided, AT/GC dropout metrics will be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and mean coverage information for every target.";
    @Option(shortName="BI", doc="An interval list file that contains the locations of the baits used.")
    public File BAIT_INTERVALS;
    @Option(shortName="TI", doc="An interval list file that contains the locations of the targets.")
    public File TARGET_INTERVALS;
    @Option(shortName="I", doc="An aligned SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Option(shortName="M", mutex={"OUTPUT"}, doc="Legacy synonym for OUTPUT, should not be used.")
    public File METRICS_FILE;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="R", optional=true, doc="The reference sequence aligned to.")
    public File REFERENCE_SEQUENCE;
    @Option(optional=true, doc="An optional file to output per target coverage information to.")
    public File PER_TARGET_COVERAGE;

    public static void main(String[] argv) {
        System.exit(new CalculateHsMetrics().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        HsMetricsCalculator allReadsCalculator;
        if (this.OUTPUT == null) {
            this.OUTPUT = this.METRICS_FILE;
        }
        IoUtil.assertFileIsReadable(this.BAIT_INTERVALS);
        IoUtil.assertFileIsReadable(this.TARGET_INTERVALS);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.PER_TARGET_COVERAGE != null) {
            IoUtil.assertFileIsWritable(this.PER_TARGET_COVERAGE);
        }
        SAMFileReader samReader = new SAMFileReader(this.INPUT);
        if (this.REFERENCE_SEQUENCE == null && this.PER_TARGET_COVERAGE != null) {
            throw new IllegalArgumentException("Must supply REFERENCE_SEQUENCE when supplying PER_TARGET_COVERAGE");
        }
        boolean calculateAll = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS);
        boolean calculateSample = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.SAMPLE);
        boolean calculateLibrary = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.LIBRARY);
        boolean calculateReadGroup = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.READ_GROUP);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)IntervalList.fromFile(this.TARGET_INTERVALS).getHeader().getSequenceDictionary(), (File)this.INPUT, (File)this.TARGET_INTERVALS);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)IntervalList.fromFile(this.BAIT_INTERVALS).getHeader().getSequenceDictionary(), (File)this.INPUT, (File)this.BAIT_INTERVALS);
        ReferenceSequenceFile ref = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)ref.getSequenceDictionary(), (File)this.INPUT, (File)this.REFERENCE_SEQUENCE);
        }
        HsMetricsCalculator hsMetricsCalculator = allReadsCalculator = calculateAll ? this.createCalculator(null, null, null, ref) : null;
        if (calculateAll && this.PER_TARGET_COVERAGE != null) {
            allReadsCalculator.setPerTargetOutput(this.PER_TARGET_COVERAGE);
        }
        HashMap<String, HsMetricsCalculator> sampleCalculators = new HashMap<String, HsMetricsCalculator>();
        HashMap<String, HsMetricsCalculator> libraryCalculators = new HashMap<String, HsMetricsCalculator>();
        HashMap<String, HsMetricsCalculator> readGroupCalculators = new HashMap<String, HsMetricsCalculator>();
        for (SAMReadGroupRecord rg : samReader.getFileHeader().getReadGroups()) {
            if (calculateSample && !sampleCalculators.containsKey(rg.getSample())) {
                sampleCalculators.put(rg.getSample(), this.createCalculator(rg.getSample(), null, null, ref));
            }
            if (calculateLibrary && !libraryCalculators.containsKey(rg.getLibrary())) {
                libraryCalculators.put(rg.getLibrary(), this.createCalculator(rg.getSample(), rg.getLibrary(), null, ref));
            }
            if (!calculateReadGroup || readGroupCalculators.containsKey(rg.getPlatformUnit())) continue;
            readGroupCalculators.put(rg.getPlatformUnit(), this.createCalculator(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit(), ref));
        }
        SAMRecordIterator records = samReader.iterator();
        int i = 0;
        while (records.hasNext()) {
            SAMRecord sam = (SAMRecord)records.next();
            if (calculateAll) {
                allReadsCalculator.analyze(sam);
            }
            if (calculateSample) {
                ((HsMetricsCalculator)sampleCalculators.get(sam.getReadGroup().getSample())).analyze(sam);
            }
            if (calculateLibrary) {
                ((HsMetricsCalculator)libraryCalculators.get(sam.getReadGroup().getLibrary())).analyze(sam);
            }
            if (calculateReadGroup) {
                ((HsMetricsCalculator)readGroupCalculators.get(sam.getReadGroup().getPlatformUnit())).analyze(sam);
            }
            if (++i % 1000000 != 0) continue;
            log.info("Processed " + i + " records so far.");
        }
        MetricsFile metrics = this.getMetricsFile();
        if (calculateAll) {
            metrics.addMetric(allReadsCalculator.getMetrics());
        }
        if (calculateSample) {
            for (HsMetricsCalculator calculator : sampleCalculators.values()) {
                metrics.addMetric(calculator.getMetrics());
            }
        }
        if (calculateLibrary) {
            for (HsMetricsCalculator calculator : libraryCalculators.values()) {
                metrics.addMetric(calculator.getMetrics());
            }
        }
        if (calculateReadGroup) {
            for (HsMetricsCalculator calculator : readGroupCalculators.values()) {
                metrics.addMetric(calculator.getMetrics());
            }
        }
        metrics.write(this.OUTPUT);
        return 0;
    }

    private HsMetricsCalculator createCalculator(String sample, String library, String readGroup, ReferenceSequenceFile ref) {
        if (this.baseCalculator == null) {
            this.baseCalculator = new HsMetricsCalculator(this.BAIT_INTERVALS, this.TARGET_INTERVALS, ref, sample, library, readGroup);
            return this.baseCalculator;
        }
        return this.baseCalculator.cloneMetricsCalculator(sample, library, readGroup);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PER_TARGET_COVERAGE != null && (this.METRIC_ACCUMULATION_LEVEL.size() != 1 || this.METRIC_ACCUMULATION_LEVEL.iterator().next() != MetricAccumulationLevel.ALL_READS)) {
            return new String[]{"PER_TARGET_COVERAGE can be specified only when METRIC_ACCUMULATION_LEVEL is set to ALL_READS."};
        }
        return super.customCommandLineValidation();
    }
}

