/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class MeanQualityByCycle
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = false;
    private HistogramGenerator q = new HistogramGenerator(false);
    private HistogramGenerator oq = new HistogramGenerator(true);

    public static void main(String[] args) {
        System.exit(new MeanQualityByCycle().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.getNotPrimaryAlignmentFlag()) {
            return;
        }
        this.q.addRecord(rec);
        this.oq.addRecord(rec);
    }

    @Override
    protected void finish() {
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(this.q.getMeanQualityHistogram());
        if (!this.oq.isEmpty()) {
            metrics.addHistogram(this.oq.getMeanQualityHistogram());
        }
        metrics.write(this.OUTPUT);
        int rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName());
        if (rResult != 0) {
            throw new PicardException("R script meanQualityByCycle.R failed with return code " + rResult);
        }
    }

    private static class HistogramGenerator {
        final boolean useOriginalQualities;
        int maxLengthSoFar = 0;
        double[] firstReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        double[] secondReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];

        private HistogramGenerator(boolean useOriginalQualities) {
            this.useOriginalQualities = useOriginalQualities;
        }

        void addRecord(SAMRecord rec) {
            byte[] quals;
            byte[] byArray = quals = this.useOriginalQualities ? rec.getOriginalBaseQualities() : rec.getBaseQualities();
            if (quals == null) {
                return;
            }
            int length = quals.length;
            boolean rc = rec.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(length + 1);
            for (int i = 0; i < length; ++i) {
                int cycle;
                int n = cycle = rc ? length - i : i + 1;
                if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                    int n2 = cycle;
                    this.secondReadTotalsByCycle[n2] = this.secondReadTotalsByCycle[n2] + (double)quals[i];
                    int n3 = cycle;
                    this.secondReadCountsByCycle[n3] = this.secondReadCountsByCycle[n3] + 1L;
                    continue;
                }
                int n4 = cycle;
                this.firstReadTotalsByCycle[n4] = this.firstReadTotalsByCycle[n4] + (double)quals[i];
                int n5 = cycle;
                this.firstReadCountsByCycle[n5] = this.firstReadCountsByCycle[n5] + 1L;
            }
        }

        private void ensureArraysBigEnough(int length) {
            if (length > this.maxLengthSoFar) {
                this.firstReadTotalsByCycle = Arrays.copyOf(this.firstReadTotalsByCycle, length);
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
                this.secondReadTotalsByCycle = Arrays.copyOf(this.secondReadTotalsByCycle, length);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
                this.maxLengthSoFar = length;
            }
        }

        Histogram<Integer> getMeanQualityHistogram() {
            String label = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
            Histogram<Integer> meanQualities = new Histogram<Integer>("CYCLE", label);
            int firstReadLength = 0;
            for (int cycle = 0; cycle < this.firstReadTotalsByCycle.length; ++cycle) {
                if (!(this.firstReadTotalsByCycle[cycle] > 0.0)) continue;
                meanQualities.increment(cycle, this.firstReadTotalsByCycle[cycle] / (double)this.firstReadCountsByCycle[cycle]);
                firstReadLength = cycle;
            }
            for (int i = 0; i < this.secondReadTotalsByCycle.length; ++i) {
                int cycle = firstReadLength + i;
                if (this.secondReadCountsByCycle[i] <= 0L) continue;
                meanQualities.increment(cycle, this.secondReadTotalsByCycle[i] / (double)this.firstReadCountsByCycle[i]);
            }
            return meanQualities;
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }
    }
}

