/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.recalibration.BaseRecalibration;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BQSRSamIterator
implements StingSAMIterator {
    private final StingSAMIterator it;
    private final BaseRecalibration bqsr;

    @Requires(value={"it != null", "bqsr != null"})
    public BQSRSamIterator(StingSAMIterator it, BaseRecalibration bqsr) {
        if (bqsr == null) {
            throw new ReviewedStingException("BUG: shouldn't create BQSRSamIterator with null recalibration object");
        }
        this.it = it;
        this.bqsr = bqsr;
    }

    @Requires(value={"hasNext()"})
    @Ensures(value={"result != null"})
    public SAMRecord next() {
        SAMRecord read = (SAMRecord)this.it.next();
        this.bqsr.recalibrateRead((GATKSAMRecord)read);
        return read;
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void close() {
        this.it.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

