/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.gcf;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.utils.codecs.vcf.IndexingVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.gcf.GCF;
import org.broadinstitute.sting.utils.gcf.GCFHeader;
import org.broadinstitute.sting.utils.gcf.GCFHeaderBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GCFWriter
extends IndexingVCFWriter {
    final boolean skipGenotypes;
    final FileOutputStream fileOutputStream;
    final DataOutputStream dataOutputStream;
    final GCFHeaderBuilder gcfHeaderBuilder;
    int nbytes = 0;
    VCFHeader header = null;
    File location;

    public GCFWriter(File location, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes) {
        super(GCFWriter.writerName((File)location, null), location, null, refDict, enableOnTheFlyIndexing);
        this.location = location;
        this.skipGenotypes = doNotWriteGenotypes;
        try {
            this.fileOutputStream = new FileOutputStream(location);
            this.dataOutputStream = GCFWriter.createDataOutputStream(this.fileOutputStream);
            this.gcfHeaderBuilder = new GCFHeaderBuilder();
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(location, (Exception)e);
        }
    }

    public void writeHeader(VCFHeader header) {
        this.header = header;
        try {
            this.nbytes += GCFHeader.writeHeader(this.dataOutputStream);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.getStreamName(), "Couldn't write header", (Exception)e);
        }
    }

    public void add(VariantContext vc) {
        super.add(vc);
        GCF gcf = new GCF(this.gcfHeaderBuilder, vc, this.skipGenotypes);
        try {
            this.nbytes += gcf.write(this.dataOutputStream);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.getStreamName(), "Failed to add gcf record " + gcf + " to stream " + this.getStreamName(), (Exception)e);
        }
    }

    public void close() {
        GCFHeader gcfHeader = this.gcfHeaderBuilder.createHeader();
        try {
            long headerPosition = this.nbytes;
            this.nbytes += gcfHeader.writeFooter(this.dataOutputStream);
            this.dataOutputStream.close();
            RandomAccessFile raFile = new RandomAccessFile(this.location, "rw");
            raFile.seek(GCFHeader.HEADER_FORWARD_REFERENCE_OFFSET);
            raFile.writeLong(headerPosition);
            raFile.close();
        }
        catch (IOException e) {
            throw new ReviewedStingException("Failed to close GCFWriter " + this.getStreamName(), e);
        }
        super.close();
    }

    private static final DataOutputStream createDataOutputStream(OutputStream stream) {
        return new DataOutputStream(new BufferedOutputStream(stream, 0x100000));
    }
}

