/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.hapmap;

import java.io.IOException;
import java.util.Arrays;
import org.broad.tribble.AbstractFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.sting.utils.codecs.hapmap.RawHapMapFeature;

public class RawHapMapCodec
extends AbstractFeatureCodec {
    private static final int minimumFeatureCount = 11;
    private String headerLine;

    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        String[] array = line.split("\\s+");
        if (array.length < 11) {
            throw new IllegalArgumentException("Unable to parse line " + line + ", the length of split features is less than the minimum of " + 11);
        }
        return new RawHapMapFeature(array[0], array[1].split("/"), array[2], Long.valueOf(array[3]), Strand.toStrand((String)array[4]), array[5], array[6], array[7], array[8], array[9], array[10], Arrays.copyOfRange(array, 11, array.length), this.headerLine);
    }

    public Class<RawHapMapFeature> getFeatureType() {
        return RawHapMapFeature.class;
    }

    public Object readHeader(LineReader reader) {
        try {
            this.headerLine = reader.readLine();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read a line from the line reader");
        }
        return this.headerLine;
    }
}

