/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.ArgumentMatch;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class CompoundArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    CompoundArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type fulltype, ArgumentMatches matches) {
        Object result;
        Class type = this.makeRawTypeIfNecessary(fulltype);
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection;
            if (Modifier.isInterface(type.getModifiers()) || Modifier.isAbstract(type.getModifiers())) {
                if (List.class.isAssignableFrom(type)) {
                    type = ArrayList.class;
                } else if (Queue.class.isAssignableFrom(type)) {
                    type = ArrayDeque.class;
                } else if (Set.class.isAssignableFrom(type)) {
                    type = TreeSet.class;
                }
            }
            Type componentType = this.getCollectionComponentType(source.field);
            ArgumentTypeDescriptor componentArgumentParser = parsingEngine.selectBestTypeDescriptor(this.makeRawTypeIfNecessary(componentType));
            try {
                collection = (Collection)type.newInstance();
            }
            catch (InstantiationException e) {
                logger.fatal((Object)("ArgumentParser: InstantiationException: cannot convert field " + source.field.getName()));
                throw new ReviewedStingException("constructFromString:InstantiationException: Failed conversion " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.fatal((Object)("ArgumentParser: IllegalAccessException: cannot convert field " + source.field.getName()));
                throw new ReviewedStingException("constructFromString:IllegalAccessException: Failed conversion " + e.getMessage());
            }
            for (ArgumentMatch match : matches) {
                for (ArgumentMatch value : match) {
                    Object object = componentArgumentParser.parse(parsingEngine, source, componentType, new ArgumentMatches(value));
                    collection.add(object);
                    parsingEngine.addTags(object, value.tags);
                }
            }
            result = collection;
        } else if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            ArgumentTypeDescriptor componentArgumentParser = parsingEngine.selectBestTypeDescriptor(this.makeRawTypeIfNecessary(componentType));
            ArrayList<ArgumentMatch> values = new ArrayList<ArgumentMatch>();
            for (ArgumentMatch match : matches) {
                for (ArgumentMatch value : match) {
                    values.add(value);
                }
            }
            result = Array.newInstance(this.makeRawTypeIfNecessary(componentType), values.size());
            int i = 0;
            for (ArgumentMatch value : values) {
                Object object = componentArgumentParser.parse(parsingEngine, source, componentType, new ArgumentMatches(value));
                Array.set(result, i++, object);
                parsingEngine.addTags(object, value.tags);
            }
        } else {
            throw new ReviewedStingException("Unsupported compound argument type: " + type);
        }
        return result;
    }

    @Override
    protected Type getCollectionComponentType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            if (parameterizedType.getActualTypeArguments().length > 1) {
                throw new IllegalArgumentException("Unable to determine collection type of field: " + field.toString());
            }
            return parameterizedType.getActualTypeArguments()[0];
        }
        return String.class;
    }
}

