/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CompositeIndex;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaTextIterator;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;

class QseqReadParser {
    public static final int MACHINE_COLUMN = 0;
    public static final int RUN__COLUMN = 1;
    public static final int LANE_COLUMN = 2;
    public static final int TILE_COLUMN = 3;
    public static final int X_COLUMN = 4;
    public static final int Y_COLUMN = 5;
    public static final int PF_COLUMN = 10;
    public static final int BASES_COLUMN = 8;
    public static final int QUALS_COLUMN = 9;
    private final IlluminaTextIterator textParser;
    private final FormatUtil formatter;
    private final Range[] sourceRanges;
    private final CompositeIndex[] destRanges;
    private final int[] copyLengths;
    protected final int readLength;

    public QseqReadParser(int lane, IlluminaFileMap tilesToReadFiles, int writeOffset, int[] outputLengths) {
        int length;
        this.textParser = new IlluminaTextIterator(lane, tilesToReadFiles);
        this.formatter = new FormatUtil();
        this.readLength = QseqReadParser.getReadLength((File)tilesToReadFiles.firstEntry().getValue());
        int bufferIndex = 0;
        while (writeOffset >= outputLengths[bufferIndex]) {
            writeOffset -= outputLengths[bufferIndex++];
        }
        int readOffset = 0;
        ArrayList<Integer> lengthsList = new ArrayList<Integer>();
        ArrayList<Range> srcRangesList = new ArrayList<Range>();
        ArrayList<CompositeIndex> dstRangesList = new ArrayList<CompositeIndex>();
        for (int coveredLength = 0; coveredLength < this.readLength; coveredLength += length) {
            length = Math.min(outputLengths[bufferIndex] - writeOffset, this.readLength - coveredLength);
            lengthsList.add(length);
            srcRangesList.add(new Range(readOffset, readOffset + length));
            dstRangesList.add(new CompositeIndex(bufferIndex, writeOffset));
            ++bufferIndex;
            writeOffset = 0;
            readOffset += length;
        }
        this.copyLengths = new int[lengthsList.size()];
        for (int i = 0; i < this.copyLengths.length; ++i) {
            this.copyLengths[i] = (Integer)lengthsList.get(i);
        }
        this.sourceRanges = srcRangesList.toArray(new Range[srcRangesList.size()]);
        this.destRanges = dstRangesList.toArray(new CompositeIndex[dstRangesList.size()]);
    }

    public void seekToTile(int oneBasedTileNumber) {
        this.textParser.seekToTile(oneBasedTileNumber);
    }

    public boolean hasNext() {
        return this.textParser.hasNext();
    }

    public void next(QseqReadData readData) {
        String[] fields = this.textParser.next();
        int lane = this.formatter.parseInt(fields[2]);
        this.textParser.validateLane(lane);
        int tile = this.formatter.parseInt(fields[3]);
        int x = this.formatter.parseInt(fields[4]);
        int y = this.formatter.parseInt(fields[5]);
        boolean pf = this.formatter.parseInt(fields[10]) == 1;
        String baseString = fields[8];
        String qualString = fields[9];
        if (baseString.length() != qualString.length()) {
            throw new PicardException("Length of bases and quals don't match in " + this.textParser.getCurrentFilename());
        }
        readData.setOrCheckLane(lane);
        readData.setOrCheckTile(tile);
        readData.setOrCheckXCoordinate(x);
        readData.setOrCheckYCoordinate(y);
        readData.setOrCheckPf(pf);
        QseqReadParser.stringToBases(baseString, this.sourceRanges, this.destRanges, readData.getBases());
        QseqReadParser.stringToQuals(qualString, this.sourceRanges, this.destRanges, this.copyLengths, readData.getQualities());
    }

    private static void stringToBases(String s, Range[] sourceRanges, CompositeIndex[] destRanges, byte[][] outputBuffers) {
        for (int i = 0; i < sourceRanges.length; ++i) {
            s.getBytes(sourceRanges[i].start, sourceRanges[i].end, outputBuffers[destRanges[i].arrayIndex], destRanges[i].elementIndex);
        }
    }

    private static void stringToQuals(String s, Range[] sourceRanges, CompositeIndex[] destRanges, int[] copyLengths, byte[][] outputBuffers) {
        QseqReadParser.stringToBases(s, sourceRanges, destRanges, outputBuffers);
        for (int i = 0; i < destRanges.length; ++i) {
            SolexaQualityConverter.getSingleton().convertSolexa_1_3_QualityCharsToPhredBinary(destRanges[i].elementIndex, copyLengths[i], outputBuffers[destRanges[i].arrayIndex]);
        }
    }

    public static int getReadLength(File qseqFile) {
        BasicInputParser parser = new BasicInputParser(true, qseqFile);
        if (!parser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + qseqFile);
        }
        String[] fields = (String[])parser.next();
        return fields[8].length();
    }
}

