/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.CollectionUtil;

class QseqParser
implements IlluminaParser<QseqReadData> {
    private final int[] outputLengths;
    private final QseqReadParser[] parsers;
    private final List<IlluminaFileMap> tileMapByReadNumber;
    private static final Set<IlluminaDataType> SupportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Position, IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.PF));

    public QseqParser(int lane, int[] outputLengths, List<IlluminaFileMap> tileMapByReadNumber) {
        this.outputLengths = outputLengths;
        this.tileMapByReadNumber = tileMapByReadNumber;
        int totalExpectedLength = 0;
        for (int i = 0; i < outputLengths.length; ++i) {
            totalExpectedLength += outputLengths[i];
        }
        int parsersIndex = 0;
        int writeOffset = 0;
        this.parsers = new QseqReadParser[tileMapByReadNumber.size()];
        for (IlluminaFileMap tileMap : tileMapByReadNumber) {
            QseqReadParser parser = new QseqReadParser(lane, tileMap, writeOffset, outputLengths);
            this.parsers[parsersIndex++] = parser;
            writeOffset += parser.readLength;
        }
        if (this.parsers.length == 0) {
            throw new PicardException("0 Qseq \"ends\" were found to parse!");
        }
        if (totalExpectedLength != writeOffset) {
            throw new PicardException("Requested read lengths(" + Arrays.toString(outputLengths) + ") span multiple clusters!  Specified read lengths do not land on Qseq cluster boundaries. " + "Total expected length(" + totalExpectedLength + ") and actual length(" + writeOffset + ")");
        }
    }

    @Override
    public void verifyData(ReadStructure readStructure, List<Integer> tiles) {
        Integer numTiles = null;
        int end = 1;
        for (IlluminaFileMap tilesToFiles : this.tileMapByReadNumber) {
            if (tiles != null && !tilesToFiles.keySet().containsAll(tiles)) {
                TreeSet<Integer> missingTiles = new TreeSet<Integer>(tiles);
                missingTiles.removeAll(tilesToFiles.keySet());
                String missing = missingTiles.first().toString();
                missingTiles.remove(missingTiles.first());
                for (Integer tile : missingTiles) {
                    missing = missing + ", " + tile;
                }
                throw new PicardException("IlluminaFileMap for \"end\" number " + end + " is missing tiles: " + missing);
            }
            if (numTiles == null) {
                numTiles = tilesToFiles.size();
            } else if (numTiles.intValue() != tilesToFiles.size()) {
                throw new PicardException("Qseq \"end\" files do not have the same number of tiles expected(" + numTiles + ") found(" + tilesToFiles.size() + ") on end (" + end + ")");
            }
            Integer numBases = null;
            for (Map.Entry tileNoToFile : tilesToFiles.entrySet()) {
                int readLength = QseqReadParser.getReadLength((File)tileNoToFile.getValue());
                if (numBases == null) {
                    numBases = readLength;
                    continue;
                }
                if (numBases == readLength) continue;
                throw new PicardException("Qseq \"end\" (" + end + ") has tiles with different numbers of bases per read.  Found on Tile(" + tileNoToFile.getKey() + ") File(" + ((File)tileNoToFile.getValue()).getAbsolutePath() + ")");
            }
            ++end;
        }
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        for (QseqReadParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
    }

    @Override
    public QseqReadData next() {
        QseqReadData qseqRd = new QseqReadData(this.outputLengths);
        for (QseqReadParser parser : this.parsers) {
            parser.next(qseqRd);
        }
        return qseqRd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + QseqParser.class.getName());
    }

    @Override
    public boolean hasNext() {
        return this.parsers[0].hasNext();
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SupportedTypes;
    }
}

