/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.illumina.parser.CompositeIndex;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaIntensityParser;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.illumina.parser.NoiseData;
import net.sf.picard.util.CollectionUtil;

class CnfParser
extends IlluminaIntensityParser<NoiseData> {
    private static final Set<IlluminaDataType> SupportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Noise));

    public CnfParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, int[] outputLengths) {
        super(directory, lane, tilesToCycleFiles, outputLengths);
    }

    @Override
    protected void addIntensityToIlluminaData(NoiseData illData, CompositeIndex index, IntensityChannel channel, short intensity) {
        illData.getNoise()[index.arrayIndex].getChannel((IntensityChannel)channel)[index.elementIndex] = intensity;
    }

    @Override
    protected NoiseData intensityToIlluminaData(final FourChannelIntensityData[] fcids) {
        return new NoiseData(){

            @Override
            public FourChannelIntensityData[] getNoise() {
                return fcids;
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SupportedTypes;
    }
}

