/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import java.util.ArrayList;

public class Pattern {
    ArrayList<String> components = new ArrayList();

    public Pattern() {
    }

    public Object clone() {
        Pattern p = new Pattern();
        p.components.addAll(this.components);
        return p;
    }

    public Pattern(String p) {
        this();
        if (p == null) {
            return;
        }
        int lastIndex = 0;
        while (true) {
            int k;
            if ((k = p.indexOf(47, lastIndex)) == -1) {
                String lastPart = p.substring(lastIndex);
                if (lastPart == null || lastPart.length() <= 0) break;
                this.components.add(p.substring(lastIndex));
                break;
            }
            String c = p.substring(lastIndex, k);
            if (c.length() > 0) {
                this.components.add(c);
            }
            lastIndex = k + 1;
        }
    }

    public void push(String s) {
        this.components.add(s);
    }

    public int size() {
        return this.components.size();
    }

    public String get(int i) {
        return this.components.get(i);
    }

    public void pop() {
        if (!this.components.isEmpty()) {
            this.components.remove(this.components.size() - 1);
        }
    }

    public String peekLast() {
        if (!this.components.isEmpty()) {
            int size = this.components.size();
            return this.components.get(size - 1);
        }
        return null;
    }

    public int getTailMatchLength(Pattern p) {
        String r;
        String l;
        if (p == null) {
            return 0;
        }
        int lSize = this.components.size();
        int rSize = p.components.size();
        if (lSize == 0 || rSize == 0) {
            return 0;
        }
        int minLen = lSize <= rSize ? lSize : rSize;
        int match = 0;
        for (int i = 1; i <= minLen && (l = this.components.get(lSize - i)).equals(r = p.components.get(rSize - i)); ++i) {
            ++match;
        }
        return match;
    }

    public int getPrefixMatchLength(Pattern p) {
        String r;
        String l;
        if (p == null) {
            return 0;
        }
        int lSize = this.components.size();
        int rSize = p.components.size();
        if (lSize == 0 || rSize == 0) {
            return 0;
        }
        int minLen = lSize <= rSize ? lSize : rSize;
        int match = 0;
        for (int i = 0; i < minLen && (l = this.components.get(i)).equals(r = p.components.get(i)); ++i) {
            ++match;
        }
        return match;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Pattern)) {
            return false;
        }
        Pattern r = (Pattern)o;
        if (r.size() != this.size()) {
            return false;
        }
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (this.get(i).equals(r.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            hc ^= this.get(i).hashCode();
        }
        return hc;
    }

    public String toString() {
        int size = this.components.size();
        String result = "";
        for (int i = 0; i < size; ++i) {
            result = result + "[" + this.components.get(i) + "]";
        }
        return result;
    }
}

