/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CloseableIterator;

public class FilterSamReads
extends CommandLineProgram {
    private static final Log log = Log.getInstance(FilterSamReads.class);
    @Usage
    public String USAGE = "Produces a new SAM or BAM file by including or excluding mapped or unmapped reads or a list of specific reads names from a SAM or BAM file";
    @Option(doc="The SAM or BAM file that will be read excluded", optional=false, shortName="I")
    public File INPUT;
    @Option(doc="Determines if reads should be included or excluded from OUTPUT SAM or BAM file", optional=false, shortName="RFT")
    public ReadFilterType READ_FILTER_TYPE;
    @Option(doc="Exclude mapped or umapped reads from the SAM or BAM", mutex={"READNAME_LIST_FILE"}, optional=false, shortName="RMT")
    public ReadMappingType READ_MAPPING_TYPE;
    @Option(doc="A file of read names that will be included or excluded from the SAM or BAM", mutex={"READ_MAPPING_TYPE"}, optional=false, shortName="RLF")
    public File READNAME_LIST_FILE;
    @Option(doc="SortOrder of the OUTPUT SAM or BAM file, otherwise use the SortOrder of the INPUT file.", optional=true, shortName="SO")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(doc="SAM or BAM file to write read excluded results to", optional=false, shortName="O")
    public File OUTPUT;

    private void filterByReadNameList() {
        BufferedReader is;
        IoUtil.assertFileIsReadable(this.READNAME_LIST_FILE);
        IoUtil.assertFileSizeNonZero(this.READNAME_LIST_FILE);
        try {
            is = IoUtil.openFileForBufferedReading(this.READNAME_LIST_FILE);
        }
        catch (IOException e) {
            throw new PicardException(e.getMessage(), e);
        }
        Scanner scanner = new Scanner(is);
        TreeSet<String> readNameFilterSet = new TreeSet<String>();
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            if (line.trim().isEmpty()) continue;
            readNameFilterSet.add(line.trim());
        }
        scanner.close();
        SAMFileReader reader = new SAMFileReader(this.INPUT);
        SAMFileHeader header = reader.getFileHeader();
        if (this.SORT_ORDER != null) {
            header.setSortOrder(this.SORT_ORDER);
        }
        log.info("SORT_ORDER of OUTPUT=" + this.OUTPUT.getName() + " will be " + header.getSortOrder().name());
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, false, this.OUTPUT);
        int count = 0;
        for (SAMRecord rec : reader) {
            if (this.READ_FILTER_TYPE.equals((Object)ReadFilterType.INCLUDE)) {
                if (readNameFilterSet.contains(rec.getReadName())) {
                    writer.addAlignment(rec);
                    ++count;
                    readNameFilterSet.remove(rec.getReadName());
                }
            } else if (readNameFilterSet.contains(rec.getReadName())) {
                readNameFilterSet.remove(rec.getReadName());
            } else {
                writer.addAlignment(rec);
                ++count;
            }
            if (count == 0 || count % 1000000 != 0) continue;
            log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + this.OUTPUT.getName());
        }
        reader.close();
        writer.close();
        log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + this.OUTPUT.getName());
        if (!readNameFilterSet.isEmpty()) {
            throw new PicardException(readNameFilterSet.size() + " reads could not be found within INPUT=" + this.INPUT.getPath() + " [" + CollectionUtil.join(readNameFilterSet, ",") + "]");
        }
        IoUtil.assertFileIsReadable(this.OUTPUT);
    }

    private SAMRecord obtainAssertedMate(CloseableIterator<SAMRecord> samRecordIterator, SAMRecord firstOfPair) {
        if (samRecordIterator.hasNext()) {
            SAMRecord secondOfPair = (SAMRecord)samRecordIterator.next();
            if (!firstOfPair.getReadName().equals(secondOfPair.getReadName())) {
                throw new PicardException("Second read from pair not found: " + firstOfPair.getReadName() + ", " + secondOfPair.getReadName());
            }
            if (!firstOfPair.getFirstOfPairFlag()) {
                throw new PicardException("First record in unmapped bam is not first of pair: " + firstOfPair.getReadName());
            }
            if (!secondOfPair.getReadPairedFlag()) {
                throw new PicardException("Second record is not marked as paired: " + secondOfPair.getReadName());
            }
            if (!secondOfPair.getSecondOfPairFlag()) {
                throw new PicardException("Second record is not second of pair: " + secondOfPair.getReadName());
            }
            return secondOfPair;
        }
        throw new PicardException("A second record does not exist: " + firstOfPair.getReadName());
    }

    private File convertToSortedByQueryName(File fileToSort) {
        SAMFileReader reader;
        SAMFileHeader header;
        File outputFile = fileToSort;
        if (!(outputFile == null || (header = (reader = new SAMFileReader(fileToSort)).getFileHeader()).getSortOrder() != null && header.getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname))) {
            log.info("Sorting " + fileToSort.getName() + " by queryname");
            outputFile = new File(this.OUTPUT.getParentFile(), IoUtil.basename(fileToSort) + ".queryname.sorted.bam");
            IoUtil.assertFileIsWritable(outputFile);
            header.setSortOrder(SAMFileHeader.SortOrder.queryname);
            SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(header, false, outputFile);
            int count = 0;
            for (SAMRecord rec : reader) {
                writer.addAlignment(rec);
                if (++count % 1000000 != 0) continue;
                log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + outputFile.getName());
            }
            reader.close();
            writer.close();
            log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + outputFile.getName());
        }
        return outputFile;
    }

    private void filterByReadMappingType() {
        SAMFileReader inputReader = new SAMFileReader(this.INPUT);
        SAMFileHeader outPutHeader = new SAMFileReader(this.INPUT).getFileHeader();
        if (this.SORT_ORDER != null) {
            outPutHeader.setSortOrder(this.SORT_ORDER);
        }
        inputReader.close();
        File inputQnSortedFile = this.convertToSortedByQueryName(this.INPUT);
        SAMFileReader reader = new SAMFileReader(inputQnSortedFile);
        log.info("SORT_ORDER of OUTPUT=" + this.OUTPUT.getName() + " will be " + outPutHeader.getSortOrder().name());
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(outPutHeader, false, this.OUTPUT);
        int count = 0;
        SAMRecordIterator it = reader.iterator();
        while (it.hasNext()) {
            SAMRecord r1 = (SAMRecord)it.next();
            boolean writeToOutput = false;
            if (r1.getReadPairedFlag()) {
                SAMRecord r2 = this.obtainAssertedMate((CloseableIterator<SAMRecord>)it, r1);
                if (this.READ_FILTER_TYPE.equals((Object)ReadFilterType.INCLUDE) && this.READ_MAPPING_TYPE.equals((Object)ReadMappingType.MAPPED) || this.READ_FILTER_TYPE.equals((Object)ReadFilterType.EXCLUDE) && this.READ_MAPPING_TYPE.equals((Object)ReadMappingType.UNMAPPED)) {
                    if (!r1.getReadUnmappedFlag() && !r2.getReadUnmappedFlag()) {
                        writeToOutput = true;
                    }
                } else if (r1.getReadUnmappedFlag() && r2.getReadUnmappedFlag()) {
                    writeToOutput = true;
                }
                if (writeToOutput) {
                    writer.addAlignment(r1);
                    writer.addAlignment(r2);
                    ++count;
                } else {
                    log.debug("Skipping " + (Object)((Object)this.READ_FILTER_TYPE) + " " + (Object)((Object)this.READ_MAPPING_TYPE) + " " + r1.toString() + " and " + r2.toString());
                }
            } else {
                if (this.READ_FILTER_TYPE.equals((Object)ReadFilterType.INCLUDE) && this.READ_MAPPING_TYPE.equals((Object)ReadMappingType.MAPPED) || this.READ_FILTER_TYPE.equals((Object)ReadFilterType.EXCLUDE) && this.READ_MAPPING_TYPE.equals((Object)ReadMappingType.UNMAPPED)) {
                    if (!r1.getReadUnmappedFlag()) {
                        writeToOutput = true;
                    }
                } else if (r1.getReadUnmappedFlag()) {
                    writeToOutput = true;
                }
                if (writeToOutput) {
                    writer.addAlignment(r1);
                    ++count;
                } else {
                    log.info("Skipping " + (Object)((Object)this.READ_FILTER_TYPE) + " " + (Object)((Object)this.READ_MAPPING_TYPE) + " " + r1.toString());
                }
            }
            if (count == 0 || count % 1000000 != 0) continue;
            log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + this.OUTPUT.getName());
        }
        reader.close();
        writer.close();
        log.info(new DecimalFormat("#,###").format(count) + " SAMRecords written to " + this.OUTPUT.getName());
        if (!inputQnSortedFile.equals(this.INPUT)) {
            log.debug("Removing temporary file " + inputQnSortedFile.getAbsolutePath());
            if (!inputQnSortedFile.delete()) {
                throw new PicardException("Failed to delete " + inputQnSortedFile.getAbsolutePath());
            }
        }
    }

    @Override
    protected int doWork() {
        if (this.INPUT.equals(this.OUTPUT)) {
            throw new PicardException("INPUT file and OUTPUT file must differ!");
        }
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            IoUtil.assertFileIsWritable(this.OUTPUT);
            if (this.READNAME_LIST_FILE != null) {
                this.filterByReadNameList();
            } else {
                this.filterByReadMappingType();
            }
            IoUtil.assertFileIsReadable(this.OUTPUT);
            return 0;
        }
        catch (Exception e) {
            if (!this.OUTPUT.delete()) {
                log.warn("Failed to delete " + this.OUTPUT.getAbsolutePath());
            }
            log.error(e, "Failed to filter " + this.INPUT.getName());
            return 1;
        }
    }

    public static void main(String[] args) {
        System.exit(new FilterSamReads().instanceMain(args));
    }

    public static enum ReadMappingType {
        MAPPED,
        UNMAPPED;

    }

    public static enum ReadFilterType {
        INCLUDE,
        EXCLUDE;

    }
}

