/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadType;

public class ReadStructure {
    public final List<ReadDescriptor> descriptors;
    public final int totalCycles;
    public final int numBarcodes;
    public final int numTemplates;
    public final int numSkips;
    public final int numDescriptors;
    public final int[] templateIndices;
    public final int[] barcodeIndices;
    public final int[] skipIndices;
    private static final String ValidTypeChars;
    private static final String ValidTypeCharsWSep;
    private static final String ReadStructureMsg;
    private static final Pattern FullPattern;
    private static final Pattern SubPattern;

    public ReadStructure(List<ReadDescriptor> collection) {
        int i;
        if (collection.size() == 0) {
            throw new IllegalArgumentException("ReadStructure does not support 0 length clusters!");
        }
        this.descriptors = Collections.unmodifiableList(collection);
        int cycles = 0;
        ArrayList<Integer> barcodeIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> templateIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> skipIndicesList = new ArrayList<Integer>();
        int descIndex = 0;
        for (ReadDescriptor desc : this.descriptors) {
            if (desc.length == 0 || desc.length < 0) {
                throw new IllegalArgumentException("ReadStructure only supports ReadDescriptor lengths > 0, found(" + desc.length + ")");
            }
            cycles += desc.length;
            switch (desc.type) {
                case B: {
                    barcodeIndicesList.add(descIndex);
                    break;
                }
                case T: {
                    templateIndicesList.add(descIndex);
                    break;
                }
                case S: {
                    skipIndicesList.add(descIndex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported ReadType (" + (Object)((Object)desc.type) + ") encountered by IlluminaRunConfiugration!");
                }
            }
            ++descIndex;
        }
        this.totalCycles = cycles;
        this.numBarcodes = barcodeIndicesList.size();
        this.numTemplates = templateIndicesList.size();
        this.numSkips = skipIndicesList.size();
        this.numDescriptors = this.descriptors.size();
        this.barcodeIndices = new int[this.numBarcodes];
        for (i = 0; i < this.numBarcodes; ++i) {
            this.barcodeIndices[i] = (Integer)barcodeIndicesList.get(i);
        }
        this.templateIndices = new int[this.numTemplates];
        for (i = 0; i < this.numTemplates; ++i) {
            this.templateIndices[i] = (Integer)templateIndicesList.get(i);
        }
        this.skipIndices = new int[this.numSkips];
        for (i = 0; i < this.numSkips; ++i) {
            this.skipIndices[i] = (Integer)skipIndicesList.get(i);
        }
    }

    public ReadStructure(String readStructureString) {
        this(ReadStructure.readStructureStringToDescriptors(readStructureString));
    }

    public String toString() {
        String out = "";
        for (ReadDescriptor rd : this.descriptors) {
            out = out + rd.toString();
        }
        return out;
    }

    private static final List<ReadDescriptor> readStructureStringToDescriptors(String readStructure) {
        Matcher fullMatcher = FullPattern.matcher(readStructure);
        if (!fullMatcher.matches()) {
            throw new IllegalArgumentException(readStructure + " cannot be parsed as a ReadStructure! " + ReadStructureMsg);
        }
        Matcher subMatcher = SubPattern.matcher(readStructure);
        ArrayList<ReadDescriptor> descriptors = new ArrayList<ReadDescriptor>();
        while (subMatcher.find()) {
            ReadDescriptor rd = new ReadDescriptor(Integer.parseInt(subMatcher.group(1)), ReadType.valueOf(subMatcher.group(2)));
            descriptors.add(rd);
        }
        return descriptors;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getClass() != thatObj.getClass()) {
            return false;
        }
        ReadStructure that = (ReadStructure)thatObj;
        if (this.descriptors.size() != that.descriptors.size()) {
            return false;
        }
        for (int i = 0; i < this.descriptors.size(); ++i) {
            if (this.descriptors.get(i).equals(that.descriptors.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int res = this.descriptors.get(0).hashCode();
        for (int i = 1; i < this.descriptors.size(); ++i) {
            res *= this.descriptors.get(i).hashCode();
        }
        return res;
    }

    static {
        String validTypes = "";
        String vtWSep = "";
        boolean written = false;
        for (ReadType rt : ReadType.values()) {
            if (written) {
                vtWSep = vtWSep + ",";
            }
            validTypes = validTypes + rt.name();
            vtWSep = vtWSep + rt.name();
        }
        ValidTypeChars = validTypes;
        ValidTypeCharsWSep = vtWSep;
        ReadStructureMsg = "Read structure must be formatted as follows: <number of bases><type><number of bases><type>...<number of bases> where number of bases is a positive (NON-ZERO) integer and type is one of the following characters " + ValidTypeCharsWSep + " (e.g. 76T8B68T would denote a paired-end run with a 76 base first end an 8 base barcode followed by a 68 base second end).";
        FullPattern = Pattern.compile("^((\\d+[" + ValidTypeChars + "]{1}))+$");
        SubPattern = Pattern.compile("(\\d+)([" + ValidTypeChars + "]{1})");
    }
}

