/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;

class IlluminaFileMap
extends TreeMap<Integer, File> {
    public IlluminaFileMap() {
    }

    public IlluminaFileMap(List<Integer> tiles, List<File> files) {
        if (tiles.size() != files.size()) {
            throw new PicardException("Tiles and Files were not of the same length: Tiles(" + tiles.size() + ") Files(" + files.size() + ") ");
        }
        for (int i = 0; i < tiles.size(); ++i) {
            this.put(tiles.get(i), files.get(i));
        }
    }

    public List<File> getFilesStartingAt(int startingTile) {
        return new ArrayList<File>(this.tailMap(startingTile).values());
    }
}

