/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.BarcodeParser;
import net.sf.picard.illumina.parser.CifParser;
import net.sf.picard.illumina.parser.CnfParser;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.QseqParser;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.illumina.parser.ReadType;

public class IlluminaDataProviderFactory {
    private final File basecallDirectory;
    private final int lane;
    private final File rawIntensityDirectory;
    private final Integer barcodeCycle;
    private final Integer barcodeLength;
    private final Set<IlluminaDataType> dataTypes;
    private int numQSeq;
    private final ReadStructure readStructure;

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, ReadStructure readStructure, IlluminaDataType ... dataTypes) {
        this.basecallDirectory = basecallDirectory;
        this.rawIntensityDirectory = basecallDirectory.getParentFile();
        this.lane = lane;
        this.barcodeCycle = null;
        this.barcodeLength = null;
        this.dataTypes = new HashSet<IlluminaDataType>(Arrays.asList(dataTypes));
        this.readStructure = readStructure == null ? this.computeReadStructure() : readStructure;
    }

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, int barcodeCycle, int barcodeLength, IlluminaDataType ... dataTypes) {
        this.basecallDirectory = basecallDirectory;
        this.rawIntensityDirectory = basecallDirectory.getParentFile();
        this.lane = lane;
        if (barcodeCycle < 1) {
            throw new IllegalArgumentException("barcodeCycle is < 1: " + barcodeCycle);
        }
        if (barcodeLength < 1) {
            throw new IllegalArgumentException("barcodeLength is < 1: " + barcodeLength);
        }
        this.barcodeCycle = barcodeCycle;
        this.barcodeLength = barcodeLength;
        this.dataTypes = new HashSet<IlluminaDataType>(Arrays.asList(dataTypes));
        this.readStructure = this.computeReadStructure();
    }

    public List<Integer> getTiles() {
        return new ArrayList<Integer>(IlluminaFileUtil.getEndedIlluminaBasecallFiles(this.basecallDirectory, "qseq", this.lane, 1).keySet());
    }

    public ReadStructure readStructure() {
        return this.readStructure;
    }

    public IlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public IlluminaDataProvider makeDataProvider(List<Integer> tiles) {
        if (this.dataTypes.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + this.basecallDirectory + ", lane " + this.lane);
        }
        int[] outputLengths = new int[this.readStructure.descriptors.size()];
        for (int i = 0; i < outputLengths.length; ++i) {
            outputLengths[i] = this.readStructure.descriptors.get((int)i).length;
        }
        int totalCycles = this.readStructure.totalCycles;
        if (!this.dataTypes.contains((Object)IlluminaDataType.Position)) {
            boolean addPosition = false;
            for (IlluminaDataType dt : this.dataTypes) {
                switch (dt) {
                    case BaseCalls: 
                    case PF: 
                    case QualityScores: {
                        addPosition = true;
                        break;
                    }
                }
            }
            if (addPosition) {
                this.dataTypes.add(IlluminaDataType.Position);
            }
        }
        HashMap<IlluminaParser, Set<IlluminaDataType>> parsersToDataType = new HashMap<IlluminaParser, Set<IlluminaDataType>>();
        TreeSet<IlluminaDataType> toSupport = new TreeSet<IlluminaDataType>(this.dataTypes);
        while (!toSupport.isEmpty()) {
            IlluminaParser parser = this.getPreferredParser((IlluminaDataType)((Object)toSupport.first()), tiles, totalCycles, outputLengths);
            HashSet<IlluminaDataType> providedTypes = new HashSet<IlluminaDataType>(parser.supportedTypes());
            providedTypes.retainAll(toSupport);
            toSupport.removeAll(providedTypes);
            parsersToDataType.put(parser, providedTypes);
        }
        for (IlluminaParser parser : parsersToDataType.keySet()) {
            parser.verifyData(this.readStructure, tiles);
        }
        return new IlluminaDataProvider(this.readStructure, parsersToDataType, this.basecallDirectory, this.lane);
    }

    private IlluminaParser getPreferredParser(IlluminaDataType dataType, List<Integer> tiles, int totalCycles, int[] outputLengths) {
        IlluminaParser<BarcodeData> parser;
        switch (dataType) {
            case Barcodes: {
                parser = new BarcodeParser(this.lane, IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(this.basecallDirectory, "barcode", this.lane, tiles));
                break;
            }
            case Noise: {
                CycleIlluminaFileMap cnfFileMap = IlluminaFileUtil.getCyledIlluminaFiles(this.rawIntensityDirectory, "cnf", this.lane, tiles, totalCycles);
                parser = new CnfParser(this.rawIntensityDirectory, this.lane, cnfFileMap, outputLengths);
                break;
            }
            case BaseCalls: 
            case PF: 
            case QualityScores: 
            case Position: {
                if (this.numQSeq == 0) {
                    this.numQSeq = IlluminaFileUtil.getNumberOfIlluminaEnds(this.basecallDirectory, "qseq", this.lane);
                }
                ArrayList<IlluminaFileMap> readTileMap = new ArrayList<IlluminaFileMap>();
                for (int i = 0; i < this.numQSeq; ++i) {
                    readTileMap.add(IlluminaFileUtil.getEndedIlluminaBasecallFiles(this.basecallDirectory, "qseq", this.lane, i + 1, tiles));
                }
                parser = new QseqParser(this.lane, outputLengths, readTileMap);
                break;
            }
            case RawIntensities: {
                CycleIlluminaFileMap cifFileMap = IlluminaFileUtil.getCyledIlluminaFiles(this.rawIntensityDirectory, "cif", this.lane, tiles, totalCycles);
                parser = new CifParser(this.rawIntensityDirectory, this.lane, cifFileMap, outputLengths);
                break;
            }
            default: {
                throw new PicardException("Unrecognized data type(" + (Object)((Object)dataType) + ") found by IlluminaDataProviderFactory!");
            }
        }
        return parser;
    }

    private ReadStructure computeReadStructure() {
        this.numQSeq = IlluminaFileUtil.getNumberOfIlluminaEnds(this.basecallDirectory, "qseq", this.lane);
        if (this.numQSeq == 0) {
            throw new PicardException("Zero Qseqs found for lane " + this.lane);
        }
        int[] qSeqLengths = new int[this.numQSeq];
        int totalReadLength = 0;
        for (int i = 0; i < this.numQSeq; ++i) {
            IlluminaFileMap files = IlluminaFileUtil.getEndedIlluminaBasecallFiles(this.basecallDirectory, "qseq", this.lane, i + 1);
            qSeqLengths[i] = QseqReadParser.getReadLength((File)files.firstEntry().getValue());
            totalReadLength += qSeqLengths[i];
        }
        ArrayList<ReadDescriptor> readDescriptors = new ArrayList<ReadDescriptor>();
        if (this.barcodeCycle != null) {
            if (this.barcodeCycle <= 0) {
                throw new PicardException("Barcode cycle( " + this.barcodeCycle + ") must be greater than 0.");
            }
            if (this.barcodeCycle != 1) {
                readDescriptors.add(new ReadDescriptor(this.barcodeCycle - 1, ReadType.Template));
            }
            readDescriptors.add(new ReadDescriptor(this.barcodeLength, ReadType.Barcode));
            int remainingLength = totalReadLength - (this.barcodeCycle - 1) - this.barcodeLength;
            if (remainingLength > 0) {
                readDescriptors.add(new ReadDescriptor(remainingLength, ReadType.Template));
            }
        } else {
            if (this.numQSeq > 2) {
                throw new PicardException("More than 2 qseqs(" + this.numQSeq + ") for non-indexed run!");
            }
            for (int i = 0; i < qSeqLengths.length; ++i) {
                readDescriptors.add(new ReadDescriptor(qSeqLengths[i], ReadType.Template));
            }
        }
        return new ReadStructure(readDescriptors);
    }
}

